/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.ProcessState;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProcessPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(ProcessPacket.class);
    private final Host host;
    private final String uuid;
    private final String luid;
    private final ProcessState state;
    private final Date submitTime;
    private final Date startTime;
    private final Date endTime;
    private final Integer exitCode;
    private final ByteBuffer payload;

    private ProcessPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            String host = ProcessPacket.readString(buffer);
            String uuid = ProcessPacket.readString(buffer);
            String luid = ProcessPacket.readString(buffer);
            Integer state = buffer.getInt();
            Integer submitTime = buffer.getInt();
            Integer startTime = buffer.getInt();
            Integer endTime = buffer.getInt();
            Integer exitCode = buffer.getInt();
            this.host = Optional.ofNullable(StringUtils.trimToNull((String)host)).map(new Function<String, Host>(){

                @Override
                public Host apply(String host) {
                    return Host.create(host);
                }
            }).orElse(null);
            this.uuid = uuid;
            this.luid = luid;
            this.state = ProcessState.fromInteger(state);
            this.submitTime = new Date(new Long(submitTime.intValue()) * 1000L);
            this.startTime = new Date(new Long(startTime.intValue()) * 1000L);
            this.endTime = new Date(new Long(endTime.intValue()) * 1000L);
            this.exitCode = exitCode;
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read process packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static ProcessPacket fromPacketPayload(InputStream stream) {
        return new ProcessPacket(stream);
    }

    private static String readString(ByteBuffer buffer) {
        Integer stringSize = buffer.getInt();
        byte[] string = new byte[stringSize.intValue()];
        buffer.get(string, 0, stringSize);
        return new String(string);
    }

    Optional<Host> getHost() {
        return Optional.ofNullable(this.host);
    }

    String getUuid() {
        return this.uuid;
    }

    String getLuid() {
        return this.luid;
    }

    ProcessState getState() {
        return this.state;
    }

    Date getSubmitTime() {
        return this.submitTime;
    }

    Date getStartTime() {
        return this.startTime;
    }

    Date getEndTime() {
        return this.endTime;
    }

    Integer getExitCode() {
        return this.exitCode;
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "ProcessPacket{host=" + this.host + ", uuid='" + this.uuid + '\'' + ", luid='" + this.luid + '\'' + ", state=" + (Object)((Object)this.state) + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exitCode=" + this.exitCode + ", payload=" + this.payload + '}';
    }
}

