/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Command;
import com.sas.launcher.client.Environment;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LaunchType;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.ProcessId;
import com.sas.launcher.client.ProcessState;
import com.sas.launcher.client.ServerProperties;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Process {
    private static final Logger logger = LoggerFactory.getLogger(Process.class);
    private final ProcessId id;
    private final LaunchType launchType;
    private final Command command;
    private final Environment environment;
    private final ServerProperties serverProperties;
    private Host host;
    private String uuid;
    private String luid;
    private ProcessState state;
    private Date submitTime;
    private Date startTime;
    private Date endTime;
    private Integer exitCode;

    private Process(Builder builder) {
        try {
            this.id = ProcessId.create();
            this.command = builder.command;
            this.environment = builder.environment;
            this.launchType = Optional.ofNullable(builder.launchType).orElse(LaunchType.DIRECT);
            this.serverProperties = builder.serverProperties;
            this.setHost(builder.host);
            this.setUuid(builder.uuid);
            this.setLuid(builder.luid);
            this.setState(builder.state);
            this.setSubmitTime(builder.submitTime);
            this.setStartTime(builder.startTime);
            this.setEndTime(builder.endTime);
            this.setExitCode(builder.exitCode);
        }
        catch (Throwable cause) {
            logger.debug("Failed to create process object: " + cause.getMessage(), cause);
            throw new LauncherRuntimeException(Error.Type.PROCESS_CREATION_ERROR.toError(new Object[0]), cause);
        }
    }

    static Builder builder() {
        return new Builder();
    }

    ProcessId getId() {
        return this.id;
    }

    LaunchType getLaunchType() {
        return this.launchType;
    }

    Boolean isDirectLaunch() {
        return this.launchType.isDirect();
    }

    Optional<Host> getHost() {
        return Optional.ofNullable(this.host);
    }

    Process setHost(Host host) {
        if (host != null) {
            this.host = host;
        }
        return this;
    }

    String getUuid() {
        return this.uuid;
    }

    Process setUuid(String uuid) {
        this.uuid = Optional.ofNullable(StringUtils.trimToNull((String)uuid)).orElse(this.uuid);
        return this;
    }

    Optional<String> getLuid() {
        return Optional.ofNullable(this.luid);
    }

    Process setLuid(String luid) {
        this.luid = Optional.ofNullable(StringUtils.trimToNull((String)luid)).orElse(this.luid);
        return this;
    }

    Optional<Date> getSubmitTime() {
        return Optional.ofNullable(this.submitTime != null ? new Date(this.submitTime.getTime()) : null);
    }

    Process setSubmitTime(Date submitTime) {
        this.submitTime = submitTime != null && submitTime.getTime() != 0L ? new Date(submitTime.getTime()) : null;
        return this;
    }

    Optional<Date> getStartTime() {
        return Optional.ofNullable(this.startTime != null ? new Date(this.startTime.getTime()) : null);
    }

    Process setStartTime(Date startTime) {
        this.startTime = startTime != null && startTime.getTime() != 0L ? new Date(startTime.getTime()) : null;
        return this;
    }

    Optional<Date> getEndTime() {
        return Optional.ofNullable(this.endTime != null ? new Date(this.endTime.getTime()) : null);
    }

    Process setEndTime(Date endTime) {
        this.endTime = endTime != null && endTime.getTime() != 0L && this.hasTerminated() != false ? new Date(endTime.getTime()) : null;
        return this;
    }

    Optional<Integer> getExitCode() {
        return Optional.ofNullable(this.exitCode);
    }

    Process setExitCode(Integer exitCode) {
        this.exitCode = exitCode != null && this.hasTerminated() != false ? exitCode : null;
        return this;
    }

    public ProcessState getState() {
        return this.state;
    }

    Process setState(ProcessState state) {
        this.state = state != null ? state : ProcessState.UNKNOWN;
        return this;
    }

    public Boolean hasTerminated() {
        return this.state.isTerminal();
    }

    public Boolean isRunning() {
        return this.hasTerminated() == false;
    }

    public String toString() {
        return "Process{host=" + this.host + ", uuid='" + this.uuid + '\'' + ", luid='" + this.luid + '\'' + ", state=" + (Object)((Object)this.state) + ", submitTime=" + this.submitTime + ", startTime=" + this.startTime + ", endTime=" + this.endTime + ", exitCode=" + this.exitCode + '}';
    }

    ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public Command getCommand() {
        return this.command;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    static class Builder {
        private Command command;
        private Environment environment;
        private LaunchType launchType;
        private ServerProperties serverProperties;
        private Host host;
        private String uuid;
        private String luid;
        private ProcessState state;
        private Date submitTime;
        private Date startTime;
        private Date endTime;
        private Integer exitCode;

        private Builder() {
        }

        Builder command(Command command) {
            this.command = command;
            return this;
        }

        Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        Builder launchType(LaunchType launchType) {
            this.launchType = launchType;
            return this;
        }

        Builder serverProperties(ServerProperties serverProperties) {
            this.serverProperties = serverProperties;
            return this;
        }

        Builder host(Host host) {
            this.host = host;
            return this;
        }

        Builder uuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        Builder luid(String luid) {
            this.luid = luid;
            return this;
        }

        Builder state(ProcessState state) {
            this.state = state;
            return this;
        }

        Builder submitTime(Date submitTime) {
            this.submitTime = submitTime;
            return this;
        }

        Builder startTime(Date startTime) {
            this.startTime = startTime;
            return this;
        }

        Builder endTime(Date endTime) {
            this.endTime = endTime;
            return this;
        }

        Builder exitCode(Integer exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        Process build() {
            return new Process(this);
        }
    }
}

