/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.AuthKerberosPacket;
import com.sas.launcher.client.AuthOAuthPacket;
import com.sas.launcher.client.AuthRequiredPacket;
import com.sas.launcher.client.AuthUserPassPacket;
import com.sas.launcher.client.DeletePacket;
import com.sas.launcher.client.DirectLaunchPacket;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.ErrorPacket;
import com.sas.launcher.client.GridInfoPacket;
import com.sas.launcher.client.GridInfoRequestPacket;
import com.sas.launcher.client.GridLaunchPacket;
import com.sas.launcher.client.InitPacket;
import com.sas.launcher.client.KillPacket;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.OKPacket;
import com.sas.launcher.client.PacketReadException;
import com.sas.launcher.client.PingPacket;
import com.sas.launcher.client.ProcessPacket;
import com.sas.launcher.client.ProductInfoRequestPacket;
import com.sas.launcher.client.ProductPacket;
import com.sas.launcher.client.ReadyPacket;
import com.sas.launcher.client.ServerInfoPacket;
import com.sas.launcher.client.ServerInfoRequestPacket;
import com.sas.launcher.client.StatusPacket;
import com.sas.launcher.client.TermPacket;
import java.io.DataInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class Packet {
    private static final Logger logger = LoggerFactory.getLogger(Packet.class);
    private static final byte[] MAGIC = new byte[]{-34, -83, -66, -17};

    Packet() {
    }

    static Packet read(InputStream inputStream) throws PacketReadException {
        DataInputStream dataStream = new DataInputStream(inputStream);
        try {
            byte[] magic = new byte[MAGIC.length];
            dataStream.read(magic, 0, MAGIC.length);
            if (!Arrays.equals(MAGIC, magic)) {
                throw new LauncherRuntimeException(Error.Type.INVALID_PACKET.toError(new Object[0]));
            }
            Type type = Type.fromInteger(dataStream.readInt());
            return type.readPayload(inputStream);
        }
        catch (Throwable cause) {
            logger.debug("Failed to read packet: " + cause.getMessage(), cause);
            throw new PacketReadException(cause);
        }
    }

    Type getType() {
        return Type.fromPacket(this);
    }

    abstract ByteBuffer getPayload();

    final byte[] serialize() {
        ByteBuffer payload = this.getPayload();
        byte[] payloadBytes = new byte[payload.limit()];
        payload.get(payloadBytes, 0, payload.limit());
        ByteBuffer data = ByteBuffer.allocate(12 + payload.limit());
        data.put(MAGIC, 0, MAGIC.length);
        data.putInt(this.getType().toInteger());
        data.putInt(payload.limit());
        data.put(payloadBytes, 0, payload.limit());
        return data.array();
    }

    final Boolean isErrorPacket() {
        return this.getType().isError();
    }

    final Boolean isPingPacket() {
        return this.getType().isPing();
    }

    final Boolean isOKPacket() {
        return this.getType().isOK();
    }

    final Boolean isReadyPacket() {
        return this.getType().isReady();
    }

    final Boolean isAuthRequiredPacket() {
        return this.getType().isAuthRequired();
    }

    final Boolean isAuthKerberosPacket() {
        return this.getType().isAuthKerberos();
    }

    static enum Type {
        INIT(0, InitPacket.class),
        DIRECT_LAUNCH(1, DirectLaunchPacket.class),
        GRID_LAUNCH(2, GridLaunchPacket.class),
        STATUS(3, StatusPacket.class),
        KILL(4, KillPacket.class),
        PROCESS(5, ProcessPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return ProcessPacket.fromPacketPayload(payload);
            }
        }
        ,
        PING(6, PingPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return PingPacket.fromPacketPayload(payload);
            }
        }
        ,
        GRIDINFO_REQUEST(7, GridInfoRequestPacket.class),
        GRIDINFO(8, GridInfoPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return GridInfoPacket.fromPacketPayload(payload);
            }
        }
        ,
        TERM(9, TermPacket.class),
        ERROR(10, ErrorPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return ErrorPacket.fromPacketPayload(payload);
            }
        }
        ,
        OK(11, OKPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return OKPacket.fromPacketPayload(payload);
            }
        }
        ,
        READY(12, ReadyPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return ReadyPacket.fromPacketPayload(payload);
            }
        }
        ,
        AUTH_REQUIRED(13, AuthRequiredPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return AuthRequiredPacket.fromPacketPayload(payload);
            }
        }
        ,
        AUTH_USERPASS(14, AuthUserPassPacket.class),
        AUTH_OAUTH(15, AuthOAuthPacket.class),
        AUTH_KERBEROS(16, AuthKerberosPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return AuthKerberosPacket.fromPacketPayload(payload);
            }
        }
        ,
        DELETE(17, DeletePacket.class),
        SERVER_INFO_REQUEST(18, ServerInfoRequestPacket.class),
        SERVER_INFO(19, ServerInfoPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return ServerInfoPacket.fromPacketPayload(payload);
            }
        }
        ,
        PRODUCT_INFO_REQUEST(20, ProductInfoRequestPacket.class),
        PRODUCT(21, ProductPacket.class){

            @Override
            Packet readPayload(InputStream payload) {
                return ProductPacket.fromPacketPayload(payload);
            }
        };

        private final int integerValue;
        private final Class packetClass;

        private Type(int integerValue, Class packetClass) {
            this.integerValue = integerValue;
            this.packetClass = packetClass;
        }

        private static Type fromPacket(Packet packet) {
            for (Type type : Type.values()) {
                if (!type.packetClass.isInstance(packet)) continue;
                return type;
            }
            return null;
        }

        private static Type fromInteger(int id) {
            for (Type type : Type.values()) {
                if (type.integerValue != id) continue;
                return type;
            }
            throw new LauncherRuntimeException(Error.Type.INVALID_PACKET_TYPE.toError(id));
        }

        Packet readPayload(InputStream payload) {
            throw new LauncherRuntimeException(Error.Type.ILLEGAL_PACKET_PAYLOAD_READ_ERROR.toError(this.name(), this.toHexString(), this.packetClass.getSimpleName()));
        }

        Integer toInteger() {
            return this.integerValue;
        }

        private String toHexString() {
            return "0x" + Integer.toHexString(this.toInteger());
        }

        private Boolean isError() {
            return this.equals((Object)ERROR);
        }

        private Boolean isPing() {
            return this.equals((Object)PING);
        }

        private Boolean isOK() {
            return this.equals((Object)OK);
        }

        private Boolean isReady() {
            return this.equals((Object)READY);
        }

        private Boolean isAuthRequired() {
            return this.equals((Object)AUTH_REQUIRED);
        }

        private Boolean isAuthKerberos() {
            return this.equals((Object)AUTH_KERBEROS);
        }
    }
}

