/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.Supplier;
import java.util.NoSuchElementException;

final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    private Optional() {
        this.value = null;
    }

    private Optional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    static <T> Optional<T> ofNullable(T value) {
        return value == null ? Optional.empty() : Optional.of(value);
    }

    T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    boolean isPresent() {
        return this.value != null;
    }

    void ifPresent(Consumer<? super T> consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    Optional<T> filter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        if (!this.isPresent()) {
            return this;
        }
        return predicate.test(this.value) ? this : Optional.empty();
    }

    <U> Optional<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Optional.ofNullable(mapper.apply(this.value));
    }

    <U> Optional<U> flatMap(Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        if (!this.isPresent()) {
            return Optional.empty();
        }
        return Objects.requireNonNull(mapper.apply(this.value));
    }

    T orElse(T other) {
        return this.value != null ? this.value : other;
    }

    T orElseGet(Supplier<? extends T> other) {
        return this.value != null ? this.value : other.get();
    }

    <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

