/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;

public enum OperatingSystem {
    ANY("ANY", null),
    LINUX("linux", "/"),
    WINDOWS("windows", "\\");

    private final String name;
    private final String pathSeparator;

    private OperatingSystem(String name, String pathSeparator) {
        this.name = name;
        this.pathSeparator = pathSeparator;
    }

    public static OperatingSystem fromString(String value) {
        for (OperatingSystem operatingSystem : OperatingSystem.values()) {
            if (!operatingSystem.getName().equals(value)) continue;
            return operatingSystem;
        }
        throw new LauncherRuntimeException(Error.Type.INVALID_OPERATING_SYSTEM.toError(value));
    }

    public String toString() {
        return "OperatingSystem{name='" + this.name + '\'' + ", pathSeparator='" + this.pathSeparator + '\'' + '}';
    }

    public Boolean isAny() {
        return this.equals((Object)ANY);
    }

    public Boolean isLinux() {
        return this.equals((Object)LINUX);
    }

    public Boolean isWindows() {
        return this.equals((Object)WINDOWS);
    }

    public String getName() {
        return this.name;
    }

    public String getPathSeparator() {
        return this.pathSeparator;
    }
}

