/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Packet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class OKPacket
extends Packet {
    private static final Logger logger = LoggerFactory.getLogger(OKPacket.class);
    private final ByteBuffer payload;

    private OKPacket(InputStream stream) {
        try {
            DataInputStream dataStream = new DataInputStream(stream);
            Integer payloadSize = dataStream.readInt();
            byte[] data = new byte[payloadSize.intValue()];
            dataStream.read(data, 0, payloadSize);
            ByteBuffer buffer = ByteBuffer.wrap(data);
            buffer.clear();
            this.payload = buffer;
        }
        catch (IOException cause) {
            logger.debug("Failed to read OK packet: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.PACKET_READ_ERROR.toError(new Object[0]), (Throwable)cause);
        }
    }

    static OKPacket fromPacketPayload(InputStream stream) {
        return new OKPacket(stream);
    }

    @Override
    ByteBuffer getPayload() {
        return this.payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "OKPacket{payload=" + this.payload + '}';
    }
}

