/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Password;

public class LauncherClientConfiguration {
    private static final String SSL_PROTOCOL_DEFAULT = "TLSv1.2";
    private static final String SSL_TRUST_MANAGER_ALGORITHM_DEFAULT = "PKIX";
    private static final String SSL_TRUST_STORE_TYPE_DEFAULT = "JKS";
    private String sslProtocol;
    private String sslTrustManagerAlgorithm;
    private String sslTrustStoreType;
    private String sslTrustStorePath;
    private Password sslTrustStorePassword;

    private LauncherClientConfiguration() {
    }

    public static LauncherClientConfiguration create() {
        return new LauncherClientConfiguration();
    }

    public String getSSLProtocol() {
        return Optional.ofNullable(this.sslProtocol).orElse(SSL_PROTOCOL_DEFAULT);
    }

    public LauncherClientConfiguration setSSLProtocol(String sslProtocol) {
        this.sslProtocol = sslProtocol;
        return this;
    }

    public String getSSLTrustManagerAlgorithm() {
        return Optional.ofNullable(this.sslTrustManagerAlgorithm).orElse(SSL_TRUST_MANAGER_ALGORITHM_DEFAULT);
    }

    public LauncherClientConfiguration setSSLTrustManagerAlgorithm(String sslTrustManagerAlgorithm) {
        this.sslTrustManagerAlgorithm = sslTrustManagerAlgorithm;
        return this;
    }

    public String getSSLTrustStoreType() {
        return Optional.ofNullable(this.sslTrustStoreType).orElse(SSL_TRUST_STORE_TYPE_DEFAULT);
    }

    public LauncherClientConfiguration setSSLTrustStoreType(String sslTrustStoreType) {
        this.sslTrustStoreType = sslTrustStoreType;
        return this;
    }

    public Optional<String> getSSLTrustStorePath() {
        return Optional.ofNullable(this.sslTrustStorePath);
    }

    public LauncherClientConfiguration setSSLTrustStorePath(String sslTrustStorePath) {
        this.sslTrustStorePath = sslTrustStorePath;
        return this;
    }

    public Optional<Password> getSSLTrustStorePassword() {
        return Optional.ofNullable(this.sslTrustStorePassword);
    }

    public LauncherClientConfiguration setSSLTrustStorePassword(Password sslTrustStorePassword) {
        this.sslTrustStorePassword = sslTrustStorePassword;
        return this;
    }
}

