/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;

public enum LaunchType {
    DIRECT("direct", 0),
    GRID("grid", 1);

    private final String name;
    private final Integer id;

    private LaunchType(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public static LaunchType fromString(String value) {
        for (LaunchType launchType : LaunchType.values()) {
            if (!launchType.getName().equals(value)) continue;
            return launchType;
        }
        throw new LauncherRuntimeException(Error.Type.INVALID_LAUNCH_TYPE.toError(value));
    }

    String getName() {
        return this.name;
    }

    public Integer getId() {
        return this.id;
    }

    public boolean isDirect() {
        return this.equals((Object)DIRECT);
    }

    public String toString() {
        return "LaunchType{name='" + this.name + '\'' + ", id=" + this.id + '}';
    }

    public boolean isGrid() {
        return this.equals((Object)GRID);
    }
}

