/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Command;
import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Environment;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.GridArmCorrelator;
import com.sas.launcher.client.GridFlags;
import com.sas.launcher.client.GridHostList;
import com.sas.launcher.client.GridInitOptions;
import com.sas.launcher.client.GridJobName;
import com.sas.launcher.client.GridJobOptions;
import com.sas.launcher.client.GridProvider;
import com.sas.launcher.client.GridResources;
import com.sas.launcher.client.Host;
import com.sas.launcher.client.LaunchType;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Port;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.ServerProperties;

public class LaunchRequest {
    private final Command command;
    private final LaunchType launchType;
    private final Environment environment;
    private final GridProvider gridProvider;
    private final Host gridServerHost;
    private final Port gridServerPort;
    private final GridInitOptions gridInitOptions;
    private final GridJobOptions gridJobOptions;
    private final GridResources gridResources;
    private final GridJobName gridJobName;
    private final GridArmCorrelator gridArmCorrelator;
    private final GridHostList gridHostList;
    private final GridFlags gridFlags;

    private LaunchRequest(Builder builder) {
        this.command = builder.command;
        this.launchType = builder.launchType;
        this.environment = builder.environment;
        this.gridProvider = builder.gridProvider;
        this.gridServerHost = builder.gridServerHost;
        this.gridServerPort = builder.gridServerPort;
        this.gridInitOptions = builder.gridInitOptions;
        this.gridJobOptions = builder.gridJobOptions;
        this.gridResources = builder.gridResources;
        this.gridJobName = builder.gridJobName;
        this.gridArmCorrelator = builder.gridArmCorrelator;
        this.gridHostList = builder.gridHostList;
        this.gridFlags = Optional.ofNullable(builder.gridFlagsBuilder).map(new Function<GridFlags.Builder, GridFlags>(){

            @Override
            public GridFlags apply(GridFlags.Builder builder) {
                return builder.build();
            }
        }).orElse(null);
    }

    public static CommandCollector builder() {
        return new Builder();
    }

    public static LaunchRequest create(String command) {
        return LaunchRequest.builder().command(command).build();
    }

    Command getCommand() {
        return this.command;
    }

    LaunchType getLaunchType() {
        return this.launchType;
    }

    Environment getEnvironment() {
        return this.environment;
    }

    ServerProperties getServerProperties() {
        return this.getLaunchType().isGrid() ? this.getGridLaunchServerProperties() : this.getDirectLaunchServerProperties();
    }

    private ServerProperties getDirectLaunchServerProperties() {
        return ServerProperties.builder().build();
    }

    private ServerProperties getGridLaunchServerProperties() {
        return ServerProperties.builder().grid(this.getGridProvider().orElse(null)).serverHost(this.getGridServerHost().orElse(null)).serverPort(this.getGridServerPort().orElse(null)).initOptions(this.getGridInitOptions().orElse(null)).jobOptions(this.getGridJobOptions().orElse(null)).jobName(this.getGridJobName().orElse(null)).resources(this.getGridResources().orElse(null)).armCorrelator(this.getGridArmCorrelator().orElse(null)).hostList(this.getGridHostList().orElse(null)).batchJob(Optional.of(this.isGridBatchJob()).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isGridBatchJob) {
                return isGridBatchJob;
            }
        }).orElse(null)).restartable(Optional.of(this.isGridRestartable()).filter(new Predicate<Boolean>(){

            @Override
            public boolean test(Boolean isGridRestartable) {
                return isGridRestartable;
            }
        }).orElse(null)).build();
    }

    private Optional<GridProvider> getGridProvider() {
        return Optional.ofNullable(this.gridProvider);
    }

    private Optional<Host> getGridServerHost() {
        return Optional.ofNullable(this.gridServerHost);
    }

    private Optional<Port> getGridServerPort() {
        return Optional.ofNullable(this.gridServerPort);
    }

    private Optional<GridInitOptions> getGridInitOptions() {
        return Optional.ofNullable(this.gridInitOptions);
    }

    private Optional<GridJobOptions> getGridJobOptions() {
        return Optional.ofNullable(this.gridJobOptions);
    }

    private Optional<GridResources> getGridResources() {
        return Optional.ofNullable(this.gridResources);
    }

    private Optional<GridJobName> getGridJobName() {
        return Optional.ofNullable(this.gridJobName);
    }

    private Optional<GridArmCorrelator> getGridArmCorrelator() {
        return Optional.ofNullable(this.gridArmCorrelator);
    }

    private Optional<GridHostList> getGridHostList() {
        return Optional.ofNullable(this.gridHostList);
    }

    private Boolean isGridBatchJob() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isBatchJob();
            }
        }).orElse(false);
    }

    private Boolean isGridRestartable() {
        return Optional.ofNullable(this.gridFlags).map(new Function<GridFlags, Boolean>(){

            @Override
            public Boolean apply(GridFlags gridFlags) {
                return gridFlags.isRestartable();
            }
        }).orElse(false);
    }

    public static class Builder
    implements CommandCollector,
    PropertiesCollector,
    GridPropertiesCollector {
        private final Environment environment;
        private final GridFlags.Builder gridFlagsBuilder;
        private Command command;
        private LaunchType launchType = LaunchType.DIRECT;
        private GridProvider gridProvider;
        private Host gridServerHost;
        private Port gridServerPort;
        private GridInitOptions gridInitOptions;
        private GridJobOptions gridJobOptions;
        private GridResources gridResources;
        private GridJobName gridJobName;
        private GridArmCorrelator gridArmCorrelator;
        private GridHostList gridHostList;

        private Builder() {
            this.environment = Environment.create();
            this.gridFlagsBuilder = GridFlags.builder();
        }

        @Override
        public PropertiesCollector command(String command) {
            this.command = Command.create(command);
            return this;
        }

        @Override
        public PropertiesCollector environment(String name, String value) {
            this.environment.set(name, value);
            return this;
        }

        @Override
        public GridPropertiesCollector gridLaunch(GridProvider gridProvider) {
            final Builder thisBuilder = this;
            this.launchType = LaunchType.DIRECT;
            Optional.ofNullable(gridProvider).ifPresent(new Consumer<GridProvider>(){

                @Override
                public void accept(GridProvider provider) {
                    thisBuilder.launchType = LaunchType.GRID;
                    thisBuilder.gridProvider = provider;
                }
            });
            return this;
        }

        @Override
        public GridPropertiesCollector gridServerHost(String gridServerHost) {
            this.gridServerHost = Host.create(gridServerHost);
            return this;
        }

        @Override
        public GridPropertiesCollector gridServerPort(Integer gridServerPort) {
            this.gridServerPort = Port.create(gridServerPort);
            return this;
        }

        @Override
        public GridPropertiesCollector gridInitOptions(String gridInitOptions) {
            this.gridInitOptions = GridInitOptions.create(gridInitOptions);
            return this;
        }

        @Override
        public GridPropertiesCollector gridJobOptions(String gridJobOptions) {
            this.gridJobOptions = GridJobOptions.create(gridJobOptions);
            return this;
        }

        @Override
        public GridPropertiesCollector gridResources(String gridResources) {
            this.gridResources = GridResources.create(gridResources);
            return this;
        }

        @Override
        public GridPropertiesCollector gridJobName(String gridJobName) {
            this.gridJobName = GridJobName.create(gridJobName);
            return this;
        }

        @Override
        public GridPropertiesCollector gridArmCorrelator(String gridArmCorrelator) {
            this.gridArmCorrelator = GridArmCorrelator.create(gridArmCorrelator);
            return this;
        }

        @Override
        public GridPropertiesCollector gridHostList(String gridHostList) {
            this.gridHostList = GridHostList.create(gridHostList);
            return this;
        }

        @Override
        public GridPropertiesCollector gridBatchJob(Boolean gridBatchJob) {
            this.gridFlagsBuilder.batchJob(gridBatchJob);
            return this;
        }

        @Override
        public GridPropertiesCollector gridRestartable(Boolean gridRestartable) {
            this.gridFlagsBuilder.restartable(gridRestartable);
            return this;
        }

        @Override
        public LaunchRequest build() {
            return new LaunchRequest(this);
        }
    }

    public static interface GridPropertiesCollector {
        public GridPropertiesCollector gridServerHost(String var1);

        public GridPropertiesCollector gridServerPort(Integer var1);

        public GridPropertiesCollector gridInitOptions(String var1);

        public GridPropertiesCollector gridJobOptions(String var1);

        public GridPropertiesCollector gridResources(String var1);

        public GridPropertiesCollector gridJobName(String var1);

        public GridPropertiesCollector gridArmCorrelator(String var1);

        public GridPropertiesCollector gridHostList(String var1);

        public GridPropertiesCollector gridBatchJob(Boolean var1);

        public GridPropertiesCollector gridRestartable(Boolean var1);

        public LaunchRequest build();
    }

    public static interface PropertiesCollector {
        public PropertiesCollector environment(String var1, String var2);

        public GridPropertiesCollector gridLaunch(GridProvider var1);

        public LaunchRequest build();
    }

    public static interface CommandCollector {
        public PropertiesCollector command(String var1);
    }
}

