/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.KerberosCredential;
import com.sas.launcher.client.KerberosSPN;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Supplier;
import java.util.Arrays;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KerberosNegotiator {
    static final Oid KERBEROS_MECHANISM = KerberosNegotiator.getOid("1.2.840.113554.1.2.2");
    static final Oid KERBEROS_NAME_TYPE = KerberosNegotiator.getOid("1.2.840.113554.1.2.2.1");
    private static final Logger logger = LoggerFactory.getLogger(KerberosNegotiator.class);
    private final ObjectFactory objectFactory;

    private KerberosNegotiator(ObjectFactory objectFactory) {
        this.objectFactory = objectFactory;
    }

    private static Oid getOid(String oidString) {
        Oid oid = null;
        try {
            oid = new Oid(oidString);
        }
        catch (GSSException cause) {
            logger.debug("Failed to create OID: " + cause.getMessage(), (Throwable)cause);
        }
        return oid;
    }

    static KerberosNegotiator create(ObjectFactory objectFactory) {
        return new KerberosNegotiator(objectFactory);
    }

    private GSSContext getGSSContext(KerberosCredential credential, KerberosSPN kerberosSPN) {
        GSSContext context;
        try {
            GSSManager manager = this.objectFactory.getGSSManager();
            logger.debug("Creating GSS name: SPN={} type={}", (Object)kerberosSPN.getValue(), (Object)KERBEROS_NAME_TYPE);
            GSSName gssName = manager.createName(kerberosSPN.getValue(), KERBEROS_NAME_TYPE);
            logger.debug("Creating GSS context: gssName={} mechanism={} gssContextLifetime={} requestMutualAuth={} requestConf={} requestInteg={} requestReplayDet={} requestSequenceDet={} requestCredDeleg={}", new Object[]{gssName.toString(), KERBEROS_MECHANISM, 0, true, true, true, true, true, credential.requiresDelegation()});
            logger.debug("Kerberos credential: {}", (Object)credential.getCredential().toString());
            context = manager.createContext(gssName, KERBEROS_MECHANISM, credential.getCredential(), 0);
            context.requestMutualAuth(true);
            context.requestConf(true);
            context.requestInteg(true);
            context.requestReplayDet(true);
            context.requestSequenceDet(true);
            context.requestCredDeleg(credential.requiresDelegation());
        }
        catch (GSSException cause) {
            logger.debug("Failed to create GSS context: " + cause.getMessage(), (Throwable)cause);
            throw new LauncherRuntimeException(Error.Type.KERBEROS_SECURITY_CONTEXT_CREATION_ERROR.toError(new Object[0]), (Throwable)cause);
        }
        return context;
    }

    void handshake(KerberosCredential credential, KerberosSPN kerberosSPN, Consumer<byte[]> tokenWriter, Supplier<byte[]> tokenReader) {
        GSSContext context = this.getGSSContext(credential, kerberosSPN);
        Integer iteration = 0;
        byte[] token = this.objectFactory.createEmptyToken();
        try {
            logger.debug("Initiating Kerberos handshake.");
            while (!context.isEstablished()) {
                Integer n = iteration;
                Integer n2 = iteration = Integer.valueOf(iteration + 1);
                logger.debug("Initializing GSS-API context: iteration={}", (Object)iteration.toString());
                logger.trace("Token: {}", (Object)Arrays.toString(token));
                token = context.initSecContext(token, 0, Optional.ofNullable(token).map(new Function<byte[], Integer>(){

                    @Override
                    public Integer apply(byte[] t) {
                        return t.length;
                    }
                }).orElse(0));
                logger.debug("GSS-API context initialization complete: iteration={}", (Object)iteration.toString());
                logger.trace("Token: {}", (Object)Arrays.toString(token));
                if (token != null) {
                    logger.debug("Writing token: iteration={}", (Object)iteration.toString());
                    tokenWriter.accept(token);
                    logger.debug("Token write succeeded: iteration={}", (Object)iteration.toString());
                }
                if (context.isEstablished()) continue;
                logger.debug("Reading token: iteration={}", (Object)iteration.toString());
                token = tokenReader.get();
                logger.debug("Token read succeeded: iteration={}", (Object)iteration.toString());
                logger.trace("Token: {}", (Object)Arrays.toString(token));
            }
        }
        catch (Throwable cause) {
            logger.debug("Kerberos handshake error: iteration={}", (Object)iteration.toString());
            logger.trace("Token: {}", (Object)Arrays.toString(token));
            throw new LauncherRuntimeException(Error.Type.KERBEROS_HANDSHAKE_ERROR.toError(new Object[0]), cause);
        }
        finally {
            try {
                logger.trace("Disposing GSS context.");
                context.dispose();
            }
            catch (GSSException cause) {
                logger.debug("Failed to dispose GSS context: " + cause.getMessage(), (Throwable)cause);
            }
        }
        logger.debug("Kerberos handshake complete: iterations={}", (Object)iteration.toString());
    }

    static class ObjectFactory {
        private ObjectFactory() {
        }

        static ObjectFactory create() {
            return new ObjectFactory();
        }

        GSSManager getGSSManager() {
            return GSSManager.getInstance();
        }

        byte[] createEmptyToken() {
            return new byte[0];
        }
    }
}

