/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.AuthKerberosPacket;
import com.sas.launcher.client.Authenticator;
import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.KerberosCredential;
import com.sas.launcher.client.KerberosNegotiator;
import com.sas.launcher.client.LauncherClientException;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.Predicate;
import com.sas.launcher.client.Server;
import com.sas.launcher.client.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KerberosAuthenticator
implements Authenticator {
    private static final Logger logger = LoggerFactory.getLogger(KerberosAuthenticator.class);
    private final KerberosCredential credential;
    private final KerberosNegotiator kerberosNegotiator;
    private final Supplier<Server> serverSupplier;
    private final Consumer<Packet> packetWriter;
    private final Supplier<Packet> packetReader;

    private KerberosAuthenticator(KerberosCredential credential, KerberosNegotiator kerberosNegotiator, Supplier<Server> serverSupplier, Consumer<Packet> packetWriter, Supplier<Packet> packetReader) {
        this.credential = credential;
        this.kerberosNegotiator = kerberosNegotiator;
        this.serverSupplier = serverSupplier;
        this.packetWriter = packetWriter;
        this.packetReader = packetReader;
    }

    static KerberosAuthenticator create(KerberosCredential credential, KerberosNegotiator kerberosNegotiator, Supplier<Server> serverSupplier, Consumer<Packet> packetWriter, Supplier<Packet> packetReader) {
        return new KerberosAuthenticator(credential, kerberosNegotiator, serverSupplier, packetWriter, packetReader);
    }

    @Override
    public void authenticate() {
        Consumer<byte[]> tokenWriter = new Consumer<byte[]>(){

            @Override
            public void accept(byte[] token) {
                try {
                    AuthKerberosPacket requestPacket = AuthKerberosPacket.create(token);
                    KerberosAuthenticator.this.packetWriter.accept(requestPacket);
                }
                catch (Throwable cause) {
                    logger.debug("Failed to write Kerberos packet: " + cause.getMessage(), cause);
                    throw new LauncherClientException(Error.Type.AUTHENTICATION_KERBEROS_PACKET_WRITE_ERROR.toError(new Object[0]), cause);
                }
            }
        };
        Supplier<byte[]> tokenReader = new Supplier<byte[]>(){

            @Override
            public byte[] get() {
                AuthKerberosPacket responsePacket = Optional.of((Packet)KerberosAuthenticator.this.packetReader.get()).filter(new Predicate<Packet>(){

                    @Override
                    public boolean test(Packet packet) {
                        return packet.isAuthKerberosPacket();
                    }
                }).map(new Function<Packet, AuthKerberosPacket>(){

                    @Override
                    public AuthKerberosPacket apply(Packet packet) {
                        return (AuthKerberosPacket)packet;
                    }
                }).orElseThrow(new Supplier<LauncherRuntimeException>(){

                    @Override
                    public LauncherRuntimeException get() {
                        return new LauncherRuntimeException(Error.Type.AUTHENTICATION_KERBEROS_INVALID_PACKET_TYPE_ERROR.toError(new Object[0]));
                    }
                });
                return responsePacket.getToken();
            }
        };
        Server server = this.serverSupplier.get();
        this.kerberosNegotiator.handshake(this.credential, server.getSPN(), tokenWriter, tokenReader);
    }
}

