/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Command;
import com.sas.launcher.client.Environment;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.LaunchPacket;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.ServerProperties;
import com.sas.launcher.client.Supplier;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Map;

final class GridLaunchPacket
extends LaunchPacket {
    private static final Charset charset = Charset.forName("UTF-8");
    private final ByteBuffer payload;

    private GridLaunchPacket(final Builder builder) {
        builder.command = Optional.ofNullable(builder.command).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_COMMAND.toError(builder.command));
            }
        });
        builder.environment = Optional.ofNullable(builder.environment).orElse(Environment.create());
        builder.properties = Optional.ofNullable(builder.properties).orElse(ServerProperties.create());
        ByteBuffer command = charset.encode(builder.command.getCommand());
        ByteBuffer options = ByteBuffer.allocate(0);
        ByteBuffer environment = this.writeMap(builder.environment.toMap());
        ByteBuffer properties = this.writeMap(builder.properties.toMap());
        ByteBuffer payload = ByteBuffer.allocate(28 + command.limit() + options.limit() + environment.limit() + properties.limit());
        payload.putInt(command.limit());
        payload.putInt(0);
        payload.putInt(options.limit());
        payload.putInt(builder.environment.variableCount());
        payload.putInt(environment.limit());
        payload.putInt(builder.properties.count());
        payload.putInt(properties.limit());
        payload.put(command.array(), 0, command.limit());
        payload.put(options.array(), 0, options.limit());
        payload.put(environment.array(), 0, environment.limit());
        payload.put(properties.array(), 0, properties.limit());
        this.payload = payload;
    }

    static Builder builder() {
        return new Builder();
    }

    private ByteBuffer writeMap(Map<String, String> map) {
        Integer totalSize = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ByteBuffer key = charset.encode(entry.getKey());
            ByteBuffer value = charset.encode(entry.getValue());
            Integer size = 8 + key.limit() + value.limit();
            ByteBuffer data = ByteBuffer.allocate(size);
            data.putInt(key.limit());
            data.putInt(value.limit());
            data.put(key.array(), 0, key.limit());
            data.put(value.array(), 0, value.limit());
            data.clear();
            buffers.add(data);
            totalSize = totalSize + size;
        }
        ByteBuffer result = ByteBuffer.allocate(totalSize);
        for (ByteBuffer buffer : buffers) {
            result.put(buffer.array(), 0, buffer.limit());
        }
        result.clear();
        return result;
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "GridLaunchPacket{payload=" + this.payload + '}';
    }

    static class Builder {
        private Command command;
        private Environment environment;
        private ServerProperties properties;

        private Builder() {
        }

        Builder command(Command command) {
            this.command = command;
            return this;
        }

        Builder environment(Environment environment) {
            this.environment = environment;
            return this;
        }

        Builder properties(ServerProperties properties) {
            this.properties = properties;
            return this;
        }

        GridLaunchPacket build() {
            return new GridLaunchPacket(this);
        }
    }
}

