/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

class GridInfo {
    private final List<String> hosts = new ArrayList<String>();
    private final Integer maxProcessingUnits;

    private GridInfo(Iterable<String> hosts, Integer maxProcessingUnits) {
        for (String host : hosts) {
            if ((host = StringUtils.trimToNull((String)host)) == null) continue;
            this.hosts.add(host);
        }
        this.maxProcessingUnits = maxProcessingUnits != null && maxProcessingUnits >= 0 ? maxProcessingUnits : 0;
    }

    static GridInfo create(List<String> hosts, Integer maxProcessingUnits) {
        return new GridInfo(hosts, maxProcessingUnits);
    }

    List<String> getHosts() {
        return Collections.unmodifiableList(this.hosts);
    }

    Integer getMaxProcessingUnits() {
        return this.maxProcessingUnits;
    }

    public String toString() {
        return "GridInfo{hosts=" + this.hosts + ", maxProcessingUnits=" + this.maxProcessingUnits + '}';
    }
}

