/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

class Environment {
    private final Map<String, String> environment = new HashMap<String, String>();

    private Environment() {
    }

    public static Environment create() {
        return new Environment();
    }

    static Environment fromMap(Map<String, String> map) {
        Environment environment = Environment.create();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                environment.set(entry.getKey(), entry.getValue());
            }
        }
        return environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Environment that = (Environment)o;
        return Objects.equals(this.environment.keySet(), that.environment.keySet());
    }

    public int hashCode() {
        return Objects.hash(this.environment);
    }

    Environment set(String name, String value) {
        name = StringUtils.trimToNull((String)name);
        value = StringUtils.trimToNull((String)value);
        if (name != null && value != null) {
            this.environment.put(name, value);
        }
        return this;
    }

    private Environment set(Variable variable) {
        return this.set(variable.getName(), variable.getValue());
    }

    Environment unset(String name) {
        if ((name = StringUtils.trimToNull((String)name)) != null) {
            this.environment.remove(name);
        }
        return this;
    }

    Environment clear() {
        this.environment.clear();
        return this;
    }

    Boolean isSet(String name) {
        return (name = StringUtils.trimToNull((String)name)) != null && this.environment.containsKey(name);
    }

    Integer variableCount() {
        return this.environment.size();
    }

    Boolean isEmpty() {
        return this.environment.isEmpty();
    }

    Optional<String> get(String name) {
        name = StringUtils.trimToNull((String)name);
        return Optional.ofNullable(this.environment.get(name));
    }

    Environment merge(Environment overlay) {
        Environment environment = Environment.create();
        for (Variable variable : this.variables()) {
            environment.set(variable);
        }
        for (Variable variable : overlay.variables()) {
            environment.set(variable);
        }
        return environment;
    }

    Map<String, String> toMap() {
        return new HashMap<String, String>(this.environment);
    }

    Iterable<Variable> variables() {
        ArrayList<Variable> variables = new ArrayList<Variable>();
        for (Map.Entry<String, String> entry : this.environment.entrySet()) {
            variables.add(Variable.create(entry.getKey(), entry.getValue()));
        }
        return variables;
    }

    public String toString() {
        return "Environment{" + this.environment + '}';
    }

    static class Variable {
        private final String name;
        private final String value;

        private Variable(String name, String value) {
            this.name = name;
            this.value = value;
        }

        private static Variable create(String name, String value) {
            return new Variable(name, value);
        }

        String getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        public String toString() {
            return "Environment.Variable{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Variable variable = (Variable)o;
            return Objects.equals(this.name, variable.name);
        }

        public int hashCode() {
            return Objects.hash(this.name);
        }
    }
}

