/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.Function;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Objects;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Supplier;
import org.apache.commons.lang3.StringUtils;

class Command {
    private final String command;

    private Command(final String command) {
        this.command = Optional.ofNullable(command).map(new Function<String, String>(){

            @Override
            public String apply(String command) {
                return StringUtils.trimToNull((String)command);
            }
        }).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.INVALID_COMMAND.toError(command));
            }
        });
    }

    public static Command create(String command) {
        return new Command(command);
    }

    public String toString() {
        return "Command{command='" + this.command + '\'' + '}';
    }

    public Integer getLength() {
        return this.command.length();
    }

    public String getCommand() {
        return this.command;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Command command = (Command)o;
        return Objects.equals(this.command, command.command);
    }

    public int hashCode() {
        return Objects.hash(this.command);
    }
}

