/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Authenticator;
import com.sas.launcher.client.Consumer;
import com.sas.launcher.client.Credential;
import com.sas.launcher.client.Error;
import com.sas.launcher.client.KerberosAuthenticator;
import com.sas.launcher.client.KerberosCredential;
import com.sas.launcher.client.KerberosNegotiator;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.Server;
import com.sas.launcher.client.Supplier;
import com.sas.launcher.client.UserPassAuthenticator;
import com.sas.launcher.client.UserPassCredential;

class AuthenticatorFactory {
    private final KerberosNegotiator kerberosNegotiator;

    private AuthenticatorFactory(KerberosNegotiator kerberosNegotiator) {
        this.kerberosNegotiator = kerberosNegotiator;
    }

    static AuthenticatorFactory create(KerberosNegotiator kerberosNegotiator) {
        return new AuthenticatorFactory(kerberosNegotiator);
    }

    Authenticator create(Credential credential, Supplier<Server> serverSupplier, Consumer<Packet> packetWriter, Supplier<Packet> packetReader) {
        Optional.ofNullable(credential).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.AUTHENTICATION_CREDENTIAL_UNAVAILABLE.toError(new Object[0]));
            }
        });
        if (credential instanceof KerberosCredential) {
            return KerberosAuthenticator.create((KerberosCredential)credential, this.kerberosNegotiator, serverSupplier, packetWriter, packetReader);
        }
        if (credential instanceof UserPassCredential) {
            return UserPassAuthenticator.create((UserPassCredential)credential, packetWriter);
        }
        throw new LauncherRuntimeException(Error.Type.AUTHENTICATION_UNSUPPORTED_CREDENTIAL_TYPE.toError(new Object[0]));
    }
}

