/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Packet;
import com.sas.launcher.client.Password;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class AuthUserPassPacket
extends Packet {
    private static final Charset charset = Charset.forName("UTF-8");
    private final String username;
    private final Password password;
    private final ByteBuffer payload;

    private AuthUserPassPacket(String username, Password password) {
        this.username = username;
        this.password = password;
        ByteBuffer usernameBuffer = charset.encode(username);
        ByteBuffer passwordBuffer = charset.encode(password.encode());
        ByteBuffer payload = ByteBuffer.allocate(4 + usernameBuffer.limit() + 4 + passwordBuffer.limit());
        payload.putInt(usernameBuffer.limit());
        payload.put(usernameBuffer.array(), 0, usernameBuffer.limit());
        payload.putInt(passwordBuffer.limit());
        payload.put(passwordBuffer.array(), 0, passwordBuffer.limit());
        this.payload = payload;
    }

    static AuthUserPassPacket create(String username, Password password) {
        return new AuthUserPassPacket(username, password);
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "AuthUserPassPacket{username='" + this.username + '\'' + ", password=" + this.password + ", payload=" + this.payload + '}';
    }

    public String getUsername() {
        return this.username;
    }

    public Password getPassword() {
        return this.password;
    }
}

