/*
 * Decompiled with CFR 0.152.
 */
package com.sas.launcher.client;

import com.sas.launcher.client.Error;
import com.sas.launcher.client.LauncherRuntimeException;
import com.sas.launcher.client.Optional;
import com.sas.launcher.client.Packet;
import com.sas.launcher.client.Supplier;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.commons.lang3.StringUtils;

final class AuthOAuthPacket
extends Packet {
    private static final Charset charset = Charset.forName("UTF-8");
    private final String token;
    private final ByteBuffer payload;

    private AuthOAuthPacket(String oauthToken) {
        this.token = oauthToken;
        ByteBuffer token = charset.encode(Optional.ofNullable(StringUtils.trimToNull((String)oauthToken)).orElseThrow(new Supplier<LauncherRuntimeException>(){

            @Override
            public LauncherRuntimeException get() {
                return new LauncherRuntimeException(Error.Type.NULL_OAUTH_TOKEN.toError(new Object[0]));
            }
        }));
        ByteBuffer payload = ByteBuffer.allocate(4 + token.limit());
        payload.putInt(token.limit());
        payload.put(token.array(), 0, token.limit());
        this.payload = payload;
    }

    static AuthOAuthPacket create(String oauthToken) {
        return new AuthOAuthPacket(oauthToken);
    }

    @Override
    public ByteBuffer getPayload() {
        ByteBuffer payload = ByteBuffer.allocate(this.payload.limit());
        payload.put(this.payload.array(), 0, this.payload.limit());
        payload.clear();
        return payload.asReadOnlyBuffer();
    }

    public String toString() {
        return "AuthOAuthPacket{token='" + this.token + '\'' + ", payload=" + this.payload + '}';
    }

    public String getToken() {
        return this.token;
    }
}

