/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.legend;

import com.sas.graphics.applets.statgraph.sgchart.attrs.ColorAttr;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillPatternAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import java.awt.Font;
import java.awt.Image;
import javax.swing.text.DefaultStyledDocument;

public class LegendItem {
    public static final int MARKER = 1;
    public static final int LINE = 2;
    public static final int FILL = 3;
    public static final int MARKERLINE = 4;
    public static final int TEXT = 5;
    public static final int IMAGEICON = 6;
    public static final int GRADIENT = 7;
    public static final int SQUARE_FILL = 1;
    public static final int CIRCLE_FILL = 2;
    private ColorAttr symbolAttrs;
    private ColorAttr secondarySymbolAttrs;
    private FillPatternAttrs fillPatternAttrs;
    private TextAttrs labelAttrs;
    private int type = -1;
    private int fillType = 1;
    private String symbolText = "";
    private DefaultStyledDocument symbolDoc = null;
    private String label;
    private DefaultStyledDocument labelDoc = null;
    private Image skinImage = null;
    private boolean skinnedLine = false;
    private int skinType = 0;
    private Image[] pixelBenderImages;
    private LineAttrs markerOutlineAttrs;
    private String userLabelAttributes = null;
    private boolean fillOutline = true;

    public LegendItem(int type) {
        this(type, "");
    }

    public LegendItem(int type, String label) {
        this.type = type;
        this.label = label;
        switch (type) {
            case 1: {
                this.symbolAttrs = new MarkerAttrs();
                this.markerOutlineAttrs = null;
                break;
            }
            case 2: {
                this.symbolAttrs = new LineAttrs();
                break;
            }
            case 3: {
                this.symbolAttrs = new FillAttrs();
                this.secondarySymbolAttrs = null;
                this.fillPatternAttrs = null;
                break;
            }
            case 4: {
                this.symbolAttrs = new MarkerAttrs();
                this.secondarySymbolAttrs = new LineAttrs();
                this.markerOutlineAttrs = null;
                break;
            }
            case 5: {
                this.symbolAttrs = new TextAttrs();
                ((TextAttrs)this.symbolAttrs).setFont(new Font("Arial", 0, 12));
            }
        }
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs) {
        this.symbolAttrs = symbol;
        this.secondarySymbolAttrs = symbol2;
        this.label = label;
        this.labelAttrs = labelAttrs;
        if (symbol instanceof MarkerAttrs) {
            this.type = symbol2 == null ? 1 : 4;
        } else if (symbol instanceof LineAttrs) {
            this.type = 2;
        } else if (symbol instanceof FillAttrs) {
            this.type = 3;
        } else if (symbol instanceof TextAttrs) {
            this.type = 5;
        }
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, Image skin) {
        this(symbol, symbol2, label, labelAttrs);
        this.skinImage = skin;
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, Image skin, int skinType) {
        this(symbol, symbol2, label, labelAttrs, skin);
        this.skinType = skinType;
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, Image skin, int skinType, Image[] pixelBenderImages) {
        this(symbol, symbol2, label, labelAttrs, skin, skinType);
        this.pixelBenderImages = pixelBenderImages;
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, boolean skinnedLine) {
        this(symbol, symbol2, label, labelAttrs);
        this.skinnedLine = skinnedLine;
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, Image skin, boolean skinnedLine) {
        this(symbol, symbol2, label, labelAttrs, skin);
        this.skinnedLine = skinnedLine;
    }

    public LegendItem(ColorAttr symbol, ColorAttr symbol2, String label, TextAttrs labelAttrs, Image skin, int skinType, boolean skinnedLine) {
        this(symbol, symbol2, label, labelAttrs, skin, skinnedLine);
        this.skinType = skinType;
    }

    public void setSymbolAttrs(ColorAttr attrs) {
        this.symbolAttrs = attrs;
    }

    public ColorAttr getSymbolAttrs() {
        return this.symbolAttrs;
    }

    public void setSecondarySymbolAttrs(ColorAttr attrs) {
        this.secondarySymbolAttrs = attrs;
    }

    public ColorAttr getSecondarySymbolAttrs() {
        return this.secondarySymbolAttrs;
    }

    public void setLabelAttrs(TextAttrs attrs) {
        this.labelAttrs = attrs;
    }

    public TextAttrs getLabelAttrs() {
        return this.labelAttrs;
    }

    public void setFillPatternAttrs(FillPatternAttrs attrs) {
        this.fillPatternAttrs = attrs;
    }

    public FillPatternAttrs getFillPatternAttrs() {
        return this.fillPatternAttrs;
    }

    public void setMarkerOutlineAttrs(LineAttrs attrs) {
        this.markerOutlineAttrs = attrs;
    }

    public LineAttrs getMarkerOutlineAttrs() {
        return this.markerOutlineAttrs;
    }

    public void setSkinImage(Image skin) {
        this.skinImage = skin;
    }

    public Image getSkinImage() {
        return this.skinImage;
    }

    public void setPixelBenderImages(Image[] imgs) {
        this.pixelBenderImages = imgs;
    }

    public Image[] getPixelBenderImages() {
        return this.pixelBenderImages;
    }

    public void setSkinnedLine(boolean skin) {
        this.skinnedLine = skin;
    }

    public boolean isSkinnedLine() {
        return this.skinnedLine;
    }

    public void setSkinType(int type) {
        this.skinType = type;
    }

    public int getSkinType() {
        return this.skinType;
    }

    public void setType(int aType) {
        this.type = aType;
    }

    public int getType() {
        return this.type;
    }

    public void setLabelDocument(DefaultStyledDocument aDoc) {
        this.labelDoc = aDoc;
    }

    public DefaultStyledDocument getLabelDocument() {
        return this.labelDoc;
    }

    public void setLabel(String aLabel) {
        this.label = aLabel;
    }

    public String getLabel() {
        return this.label;
    }

    public void setSymbolDocument(DefaultStyledDocument aDoc) {
        this.symbolDoc = aDoc;
    }

    public DefaultStyledDocument getSymbolDocument() {
        return this.symbolDoc;
    }

    public void setSymbolText(String text) {
        this.symbolText = text;
    }

    public String getSymbolText() {
        return this.symbolText;
    }

    public void setUserLabelAttributes(String attributes) {
        this.userLabelAttributes = attributes;
    }

    public String getUserLabelAttributes() {
        return this.userLabelAttributes;
    }

    public void setFillType(int type) {
        switch (type) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return;
            }
        }
        this.fillType = type;
    }

    public int getFillType() {
        return this.fillType;
    }

    public boolean isValid(int attr) {
        if (this.type < 1 || this.type > 5) {
            return false;
        }
        if (attr == 0) {
            return true;
        }
        switch (this.type) {
            case 1: {
                return attr == 9 || attr == 3 || attr == 2 || attr == 1;
            }
            case 2: {
                return attr == 10 || attr == 4 || attr == 5 || attr == 6;
            }
            case 3: {
                if (attr == 11 || attr == 7) {
                    return true;
                }
                if (this.fillPatternAttrs != null && attr == 8) {
                    return true;
                }
                return this.secondarySymbolAttrs != null && (attr == 10 || attr == 4 || attr == 5 || attr == 6);
            }
            case 4: {
                return attr == 9 || attr == 3 || attr == 2 || attr == 1 || attr == 10 || attr == 4 || attr == 5 || attr == 6;
            }
            case 5: {
                return attr == 16;
            }
        }
        return false;
    }

    public boolean isFillOutline() {
        return this.fillOutline;
    }

    public void setFillOutline(boolean fillOutline) {
        this.fillOutline = fillOutline;
    }
}

