/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.RangeAttributeMap;
import com.sas.graphics.util.attrmap.RangeColorMapper;
import com.sas.text.SASFormat;
import java.util.Vector;

public class RangeColorMapperFactory {
    public static String validateMap(RangeAttributeMap rangeAttrMap, double min, double max) {
        if (rangeAttrMap == null || !rangeAttrMap.isValid()) {
            return null;
        }
        Vector<AttributeMapRange> dataRanges = new Vector<AttributeMapRange>();
        for (int i = 0; i < rangeAttrMap.size(); ++i) {
            AttributeMapRange dr = new AttributeMapRange(rangeAttrMap.getRange(i));
            dr.bindToDataMinMax(min, max);
            dataRanges.add(dr);
        }
        return RangeAttributeMap.validateRanges(dataRanges);
    }

    public static RangeColorMapper getInstance(RangeAttributeMap rangeAttrMap, double min, double max, Style style, boolean contrastColors, SASFormat format) {
        if (rangeAttrMap == null || !rangeAttrMap.isValid()) {
            return null;
        }
        Vector<AttributeMapRange> dataRanges = new Vector<AttributeMapRange>();
        for (int i = 0; i < rangeAttrMap.size(); ++i) {
            AttributeMapRange dr = new AttributeMapRange(rangeAttrMap.getRange(i));
            dr.bindToDataMinMax(min, max);
            dataRanges.add(dr);
        }
        if (!RangeAttributeMap.isValid(dataRanges)) {
            return null;
        }
        return new RangeColorMapper(dataRanges, min, max, style, rangeAttrMap.isMissingDefined(), rangeAttrMap.getMissingAttrs(), rangeAttrMap.isOtherDefined(), rangeAttrMap.getOtherAttrs(), rangeAttrMap.isUnderflowDefined(), rangeAttrMap.getUnderflowAttrs(), rangeAttrMap.isOverflowDefined(), rangeAttrMap.getOverflowAttrs(), contrastColors, format);
    }
}

