/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.AttributeMapRange;
import com.sas.graphics.util.attrmap.ParserUtils;
import com.sas.graphics.util.attrmap.RB;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import java.text.MessageFormat;
import java.util.Vector;

public class RangeAttributeMap {
    private String name = null;
    private Vector<AttributeMapRange> ranges = null;
    public static final String RB_KEY = "RangeAttributeMap.";
    private RangeAttrBundle missingAttrs;
    private RangeAttrBundle otherAttrs;
    private RangeAttrBundle underflowAttrs;
    private RangeAttrBundle overflowAttrs;
    private boolean missingDefined = false;
    private boolean otherDefined = false;
    private boolean underflowDefined = false;
    private boolean overflowDefined = false;

    public RangeAttributeMap(String name) {
        this.name = name;
        this.ranges = new Vector();
        this.missingAttrs = new RangeAttrBundle();
        this.otherAttrs = new RangeAttrBundle();
        this.underflowAttrs = new RangeAttrBundle();
        this.overflowAttrs = new RangeAttrBundle();
    }

    public String getName() {
        return this.name;
    }

    public void addRange(AttributeMapRange r) {
        if (!this.contains(r)) {
            this.ranges.add(r);
        }
    }

    public AttributeMapRange getRange(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return this.ranges.get(index);
    }

    public boolean contains(AttributeMapRange r) {
        if (r == null) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (!r.equalTo(this.getRange(i))) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.ranges.size();
    }

    public void clear() {
        this.ranges.clear();
    }

    public boolean isValid() {
        return RangeAttributeMap.isValid(this.ranges);
    }

    public static boolean isValid(Vector<AttributeMapRange> ranges) {
        if (ranges == null) {
            return false;
        }
        if (ranges.size() < 1) {
            return false;
        }
        if (!ranges.get(0).isValid()) {
            return false;
        }
        for (int i = 0; i < ranges.size() - 1; ++i) {
            for (int j = i + 1; j < ranges.size(); ++j) {
                if (ranges.get(j).isValid() && !ranges.get(i).overlaps(ranges.get(j))) continue;
                return false;
            }
        }
        return true;
    }

    public static String validateRanges(Vector<AttributeMapRange> ranges) {
        if (ranges == null || ranges.size() < 1) {
            return RB.getStringResource(RB_KEY, "EmptyRangeList.txt");
        }
        String err = ranges.get(0).validateRange();
        if (err != null) {
            return err;
        }
        for (int i = 0; i < ranges.size() - 1; ++i) {
            for (int j = i + 1; j < ranges.size(); ++j) {
                err = ranges.get(j).validateRange();
                if (err != null) {
                    return err;
                }
                if (!ranges.get(i).overlaps(ranges.get(j))) continue;
                String s = RB.getStringResource(RB_KEY, "OverlappingRanges.fmt.txt");
                return MessageFormat.format(s, "RangeAttrMap", ranges.get(i), ranges.get(j));
            }
        }
        return null;
    }

    public Vector<AttributeMapRange> getRanges() {
        return this.ranges;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RangeAttributeMap ");
        sb.append("name=" + this.name + " ");
        sb.append("size=" + this.size() + " ");
        sb.append("\n\n");
        for (int i = 0; i < this.size(); ++i) {
            sb.append("AttributeMapRange " + (i + 1) + " " + this.getRange(i));
        }
        return sb.toString();
    }

    public RangeAttrBundle getMissingAttrs() {
        return this.missingAttrs;
    }

    public void setMissingAttrs(RangeAttrBundle missingAttrs) {
        this.missingAttrs = missingAttrs;
    }

    public RangeAttrBundle getOtherAttrs() {
        return this.otherAttrs;
    }

    public void setOtherAttrs(RangeAttrBundle otherAttrs) {
        this.otherAttrs = otherAttrs;
    }

    public RangeAttrBundle getUnderflowAttrs() {
        return this.underflowAttrs;
    }

    public void setUnderflowAttrs(RangeAttrBundle underflowAttrs) {
        this.underflowAttrs = underflowAttrs;
    }

    public RangeAttrBundle getOverflowAttrs() {
        return this.overflowAttrs;
    }

    public void setOverflowAttrs(RangeAttrBundle overflowAttrs) {
        this.overflowAttrs = overflowAttrs;
    }

    public void applyStyle(Style style) {
        for (int i = 0; i < this.ranges.size(); ++i) {
            this.ranges.get(i).applyStyle(style);
        }
        this.missingAttrs.applyStyle(style);
        this.otherAttrs.applyStyle(style);
        if (this.otherAttrs.getKPIColor() == null) {
            this.otherAttrs.setKPIColor(ParserUtils.parseColor("Other:color", style));
        }
        this.underflowAttrs.applyStyle(style);
        this.overflowAttrs.applyStyle(style);
    }

    public boolean isMissingDefined() {
        return this.missingDefined;
    }

    public void setMissingDefined(boolean missingDefined) {
        this.missingDefined = missingDefined;
    }

    public boolean isOtherDefined() {
        return this.otherDefined;
    }

    public void setOtherDefined(boolean otherDefined) {
        this.otherDefined = otherDefined;
    }

    public boolean isUnderflowDefined() {
        return this.underflowDefined;
    }

    public void setUnderflowDefined(boolean underflowDefined) {
        this.underflowDefined = underflowDefined;
    }

    public boolean isOverflowDefined() {
        return this.overflowDefined;
    }

    public void setOverflowDefined(boolean overflowDefined) {
        this.overflowDefined = overflowDefined;
    }
}

