/*
 * Decompiled with CFR 0.152.
 */
package com.sas.graphics.util.attrmap;

import com.sas.graphics.styles.Style;
import com.sas.graphics.util.attrmap.RB;
import com.sas.graphics.util.attrmap.RangeAttrBundle;
import com.sas.graphics.util.attrmap.RangeBound;
import com.sas.text.SASFormat;
import java.text.MessageFormat;

public class AttributeMapRange {
    public static final String RB_KEY = "Range.";
    private RangeBound min;
    private RangeBound max;
    private RangeAttrBundle rangeAttrs;

    public AttributeMapRange(RangeBound min, RangeBound max, RangeAttrBundle rangeAttrs) {
        this.min = min;
        this.max = max;
        this.rangeAttrs = rangeAttrs;
    }

    public AttributeMapRange(AttributeMapRange r) {
        if (r != null) {
            this.min = new RangeBound(r.getMin());
            this.max = new RangeBound(r.getMax());
            this.rangeAttrs = new RangeAttrBundle(r.getRangeAttrBundle());
        }
    }

    public RangeBound getMin() {
        return this.min;
    }

    public RangeBound getMax() {
        return this.max;
    }

    public RangeAttrBundle getRangeAttrBundle() {
        return this.rangeAttrs;
    }

    public void setRangeAttrBundle(RangeAttrBundle rangeAttrs) {
        this.rangeAttrs = rangeAttrs;
    }

    public boolean isValid() {
        if (this.min == null || this.max == null) {
            return false;
        }
        if (!this.min.isDataBound() && this.min.getKeyword() != null || !this.max.isDataBound() && this.max.getKeyword() != null) {
            return true;
        }
        if (Double.isNaN(this.min.getValue()) || Double.isNaN(this.max.getValue())) {
            return false;
        }
        return !(this.min.getValue() > this.max.getValue());
    }

    private String buildErrorMessage(String msg, Object[] args) {
        return MessageFormat.format(msg, args);
    }

    public String validateRange() {
        if (this.min == null) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Min.Undefined.fmt.txt"), new Object[]{this});
        }
        if (this.max == null) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Max.Undefined.fmt.txt"), new Object[]{this});
        }
        if (!this.min.isDataBound() && this.min.getKeyword() != null || !this.max.isDataBound() && this.max.getKeyword() != null) {
            return null;
        }
        if (Double.isNaN(this.min.getValue())) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Min.Undefined.fmt.txt"), new Object[]{this});
        }
        if (Double.isNaN(this.max.getValue())) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Max.Undefined.fmt.txt"), new Object[]{this});
        }
        if (this.min.getValue() > this.max.getValue()) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Invalid.fmt.txt"), new Object[]{this});
        }
        if (this.min.getValue() == this.max.getValue() && this.min.isInclusive() && !this.max.isInclusive()) {
            return this.buildErrorMessage(RB.getStringResource(RB_KEY, "Invalid.fmt.txt"), new Object[]{this});
        }
        return null;
    }

    public boolean overlaps(AttributeMapRange r) {
        if (r == null || !r.isValid() || !this.isValid()) {
            return false;
        }
        return this.getLength() < r.getLength() ? r.contains(this.min) || r.contains(this.max) : this.contains(r.getMin()) || this.contains(r.getMax());
    }

    private double getLength() {
        return this.max.getValue() - this.min.getValue();
    }

    public boolean contains(RangeBound rb) {
        if (rb == null || !this.isValid()) {
            return false;
        }
        if (!rb.isDataBound() && rb.getKeyword() != null || !this.min.isDataBound() && this.min.getKeyword() != null || !this.max.isDataBound() && this.max.getKeyword() != null) {
            return false;
        }
        return rb.getValue() > this.min.getValue() && rb.getValue() < this.max.getValue();
    }

    public boolean contains(double value) {
        if (!this.isValid()) {
            return false;
        }
        if (!this.min.isDataBound() && this.min.getKeyword() != null || !this.max.isDataBound() && this.max.getKeyword() != null) {
            return false;
        }
        boolean minCriteria = false;
        boolean maxCriteria = false;
        if (this.min.isInclusive() && this.min.getValue() <= value || !this.min.isInclusive() && this.min.getValue() < value) {
            minCriteria = true;
        }
        if (this.max.isInclusive() && this.max.getValue() >= value || !this.max.isInclusive() && this.max.getValue() > value) {
            maxCriteria = true;
        }
        return minCriteria && maxCriteria;
    }

    public boolean equalTo(AttributeMapRange r) {
        return r != null && this.getMin().equalTo(r.getMin()) && this.getMax().equalTo(r.getMax());
    }

    void bindToDataMinMax(double min, double max) {
        if (this.min != null) {
            this.min.bindToDataMinMax(min, max);
        }
        if (this.max != null) {
            this.max.bindToDataMinMax(min, max);
        }
    }

    void applyStyle(Style style) {
        if (style == null || this.rangeAttrs == null) {
            return;
        }
        this.rangeAttrs.applyStyle(style);
    }

    String getMathematicalRepresentation(SASFormat format) {
        StringBuffer sb = new StringBuffer();
        if (this.min != null && this.max != null) {
            sb.append(this.min.isInclusive() ? "[" : "(");
            String dval1 = format != null ? format.format((Object)this.min.getValue()).trim() : Double.toString(this.min.getValue());
            sb.append(this.min.isKeyword() ? this.min.getKeyword() : dval1);
            sb.append(", ");
            String dval2 = format != null ? format.format((Object)this.max.getValue()).trim() : Double.toString(this.max.getValue());
            sb.append(this.max.isKeyword() ? this.max.getKeyword() : dval2);
            sb.append(this.max.isInclusive() ? "]" : ")");
        }
        return sb.toString();
    }

    public String toString() {
        return this.getMathematicalRepresentation(null);
    }

    public String getLabel(SASFormat format) {
        String label = this.rangeAttrs.getLabel();
        if (label == null) {
            label = this.getMathematicalRepresentation(format);
        }
        return label;
    }
}

