/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.migration;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.migration.RB;
import com.sas.util.Strings;
import com.sas.util.UsageVersion;
import com.sas.workspace.Workspace;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;

public class UpgradeOLAPSchemaAction {
    private static final String EMPTY_STRING;
    private Tree folder;
    Root jomaOLAPSchema;
    private static final String MDEXCEPTION_MESSAGE;
    private MdObjectStore objectStore;
    private static final List OLAPSCHEMA_ASSOCIATIONS;
    private static final int OLAPSCHEMA_VERSION_MAJOR_NUMBER;
    private static final int OLAPSCHEMA_VERSION_MICRO_NUMBER;
    private static final int OLAPSCHEMA_VERSION_MINOR_NUMBER;
    private static final String READ_OLAPSCHEMA_TEMPLATE;
    private static final String SHARED_DATA_NAME;
    private static final StringBuffer SHARED_DATA_XML_SELECT;
    private static boolean testing;
    private static final String TREE_TYPE;
    private static final String TREE_PUBLIC_TYPE;
    private static final int TREE_VERSION_MAJOR_NUMBER;
    private static final int TREE_VERSION_MICRO_NUMBER;
    private static final int TREE_VERSION_MINOR_NUMBER;
    OLAPSchema upgradedOLAPSchema;

    public static UpgradeOLAPSchemaAction getUpgradeOLAPSchemaAction(OLAPSchema inputSchema) throws RemoteException, MdException {
        return new UpgradeOLAPSchemaAction(inputSchema);
    }

    UpgradeOLAPSchemaAction(OLAPSchema inputOLAPSchema) throws RemoteException, MdException {
        this.jomaOLAPSchema = inputOLAPSchema;
        Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.jomaOLAPSchema, null, OLAPSCHEMA_ASSOCIATIONS, READ_OLAPSCHEMA_TEMPLATE, 8);
        this.objectStore = (MdObjectStore)this.jomaOLAPSchema.getObjectStore();
    }

    private void upgradeOLAPSchemaVersion() throws RemoteException, MdException {
        UsageVersion usageVersion;
        double jomaVersion = this.upgradedOLAPSchema.getUsageVersion();
        if (jomaVersion != (usageVersion = new UsageVersion(OLAPSCHEMA_VERSION_MAJOR_NUMBER, OLAPSCHEMA_VERSION_MINOR_NUMBER, OLAPSCHEMA_VERSION_MICRO_NUMBER)).encode()) {
            this.upgradedOLAPSchema.setUsageVersion(usageVersion.encode());
        }
    }

    private void upgradeOLAPSchemaPublicType() throws RemoteException, MdException {
        if (UpgradeOLAPSchemaAction.isBlank(this.upgradedOLAPSchema.getPublicType())) {
            this.upgradedOLAPSchema.setPublicType("OLAPSchema");
        }
    }

    private Tree getSharedDataFolder() throws RemoteException, MdException {
        int flags = 8456;
        List tempAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)this.objectStore, Workspace.getMdFactory().getOMIUtil().getFoundationReposID(), "Tree", flags, SHARED_DATA_XML_SELECT.toString());
        List temp = Workspace.removeCheckouts((List)tempAll);
        Tree sharedData = null;
        for (int i = temp.size() - 1; i >= 0 && sharedData == null; --i) {
            sharedData = (Tree)temp.get(i);
            if (sharedData.getName().equalsIgnoreCase(SHARED_DATA_NAME)) continue;
            sharedData = null;
        }
        return sharedData;
    }

    private void upgradeOLAPSchemaFolder() throws RemoteException, MdException {
        Tree sharedData = this.getSharedDataFolder();
        String fqid = Workspace.getMdFactory().getOMIUtil().getReposIdFromMetadataObject((CMetadata)sharedData);
        Tree schemaFolder = this.createTree(fqid.substring(9, 17));
        schemaFolder.setName(this.upgradedOLAPSchema.getName());
        schemaFolder.setTreeType(TREE_TYPE);
        schemaFolder.setPublicType(TREE_PUBLIC_TYPE);
        UsageVersion usageVersion = new UsageVersion(TREE_VERSION_MAJOR_NUMBER, TREE_VERSION_MINOR_NUMBER, TREE_VERSION_MICRO_NUMBER);
        schemaFolder.setUsageVersion(usageVersion.encode());
        schemaFolder.setParentTree(sharedData);
        AssociationList trees = this.upgradedOLAPSchema.getTrees(false);
        trees.add((Object)schemaFolder);
    }

    private void upgradeOLAPSchemaCubes() throws RemoteException, MdException {
        AssociationList cubes = this.upgradedOLAPSchema.getCubes(false);
        Tree folder = (Tree)this.upgradedOLAPSchema.getTrees(false).get(0);
        for (int i = cubes.size() - 1; i >= 0; --i) {
            Cube cube = (Cube)cubes.get(i);
            AssociationList trees = cube.getTrees(true);
            if (!trees.isEmpty()) continue;
            trees.add((Object)folder);
        }
    }

    private boolean upgradeOLAPSchema() throws RemoteException, MdException {
        boolean upgrade = this.upgradedOLAPSchema.getTrees().isEmpty();
        if (upgrade) {
            this.upgradeOLAPSchemaPublicType();
            this.upgradeOLAPSchemaVersion();
            this.upgradeOLAPSchemaFolder();
            this.upgradeOLAPSchemaCubes();
        }
        return upgrade;
    }

    public void upgrade() throws RemoteException, MdException {
        this.upgradedOLAPSchema = (OLAPSchema)this.jomaOLAPSchema;
        try {
            boolean upgrade = this.upgradeOLAPSchema();
            if (upgrade) {
                this.updateMetadata();
            }
        }
        catch (RemoteException e) {
            this.upgradedOLAPSchema = null;
            throw e;
        }
        catch (MdException e) {
            this.upgradedOLAPSchema = null;
            throw e;
        }
    }

    void setTesting(boolean inputTesting) {
        testing = inputTesting;
    }

    private void updateMetadata() throws RemoteException, MdException {
        if (!testing && this.upgradedOLAPSchema != null) {
            this.upgradedOLAPSchema.updateMetadataAll();
            AssociationList cubes = this.upgradedOLAPSchema.getCubes(false);
            for (int i = cubes.size() - 1; i >= 0; --i) {
                Cube cube = (Cube)cubes.get(i);
                cube.updateMetadataAll();
            }
        }
    }

    private static boolean isBlank(String value) {
        return value == null || Strings.trimmedLength((String)value) == 0;
    }

    private Tree createTree(String shortFQID) {
        Tree tree = null;
        try {
            tree = (Tree)Workspace.getMdFactory().createComplexMetadataObject(this.objectStore, EMPTY_STRING, "Tree", shortFQID);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return tree;
    }

    static {
        testing = false;
        MDEXCEPTION_MESSAGE = RB.getStringResource("MdException.GenericError.txt");
        EMPTY_STRING = "";
        OLAPSCHEMA_VERSION_MAJOR_NUMBER = 1;
        OLAPSCHEMA_VERSION_MICRO_NUMBER = 0;
        OLAPSCHEMA_VERSION_MINOR_NUMBER = 0;
        SHARED_DATA_NAME = "Shared Data";
        TREE_TYPE = "BIP Folder";
        TREE_PUBLIC_TYPE = "Folder";
        TREE_VERSION_MAJOR_NUMBER = 1;
        TREE_VERSION_MICRO_NUMBER = 0;
        TREE_VERSION_MINOR_NUMBER = 0;
        OLAPSCHEMA_ASSOCIATIONS = new ArrayList();
        OLAPSCHEMA_ASSOCIATIONS.add("Cubes");
        OLAPSCHEMA_ASSOCIATIONS.add("Trees");
        READ_OLAPSCHEMA_TEMPLATE = "<Templates><Cube><Trees/></Cube><Tree><Members/></Tree></Templates>";
        StringBuffer template = new StringBuffer();
        template.append("Tree[@Name = '");
        template.append("Shared Data");
        template.append("']");
        SHARED_DATA_XML_SELECT = new StringBuffer();
        try {
            SHARED_DATA_XML_SELECT.append("<GetMetadataObjects><Reposid>");
            SHARED_DATA_XML_SELECT.append(Workspace.getMdFactory().getOMIUtil().getFoundationReposID());
            SHARED_DATA_XML_SELECT.append("</Reposid><Type>");
            SHARED_DATA_XML_SELECT.append("Tree");
            SHARED_DATA_XML_SELECT.append("</Type><Objects/><NS>SAS</NS><Flags>");
            SHARED_DATA_XML_SELECT.append(8320);
            SHARED_DATA_XML_SELECT.append("</Flags><Options>");
            SHARED_DATA_XML_SELECT.append("<XMLSelect search=\"");
            SHARED_DATA_XML_SELECT.append(Matcher.quoteReplacement(template.toString()));
            SHARED_DATA_XML_SELECT.append("']]\"/>");
            SHARED_DATA_XML_SELECT.append("<Templates></Templates>");
            SHARED_DATA_XML_SELECT.append("</Options>");
            SHARED_DATA_XML_SELECT.append("</GetMetadataObjects>");
        }
        catch (RemoteException e) {
            SHARED_DATA_XML_SELECT.setLength(0);
        }
        catch (MdException e) {
            SHARED_DATA_XML_SELECT.setLength(0);
        }
    }
}

