/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.migration;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.batch.BatchDriver2;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.DataTable;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.Job;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdLibGenInterface;
import com.sas.metadata.remote.MdModelUtil;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.SASLibrary;
import com.sas.metadata.remote.Text;
import com.sas.metadata.remote.TextStore;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.TransformationActivity;
import com.sas.metadata.remote.TransformationStep;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.migration.CubeShortFormOptions;
import com.sas.olapadmin.migration.RB;
import com.sas.services.ServiceException;
import com.sas.services.session.SessionContextInterface;
import com.sas.text.Message;
import com.sas.util.Strings;
import com.sas.workspace.LibraryUtil;
import com.sas.workspace.Workspace;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class CubeShortForm
extends BatchDriver2 {
    private final String newline = System.getProperty("line.separator");
    private static final String PROCOLAP = "PROC OLAP";
    private static final String CUBEEQUALS = "   CUBE     = ";
    private static final String METASVR = "   METASVR";
    private static final String OLAPSCHEMA = "      OLAP_SCHEMA = ";
    private static final String VALIDVARNAMESYNTAX = "OPTIONS VALIDVARNAME=ANY;";
    private static final String VALIDVARNAME = "VALIDVARNAME";
    private static final String VALIDVARNAMESMALL = "validvarname";
    private static final String STARDIM = "STARDIM";
    private static final String STARFACT = "STARFACT";
    private static final String AGGREGATE = "AGGREGATE";
    private static final String FORMATSEARCH = "OPTIONS FMTSEARCH = (";
    private static final String RUN = "   RUN;";
    private static final String OLAP_SASCODE = "OLAPSASCode";
    private static final String SEMICOLON = ";";
    private static final String PREPROCESS = "PreProcess";
    private static final String POSTPROCESS = "PostProcess";
    private static final String FIRSTCOMMENT = "/***************************";
    private static final String LASTCOMMENT = "***************************/";
    private String directory;
    private String systemtype;
    private Cube jomaCube;
    private Job jomaJob;
    private static List cubeAssociations;
    public static final String READ_CUBE_TEMPLATE = "<Templates><ClassifierMap><ClassifierSources/><TransformationSources/><Steps/></ClassifierMap><TransformationStep><Activities/></TransformationStep><TransformationActivity><Jobs/></TransformationActivity><Job><TransformationSources/><TransformationTargets/></Job><Transformation><isUserDefined/><TransformRole/><SourceCode/></Transformation><TextStore><StoredText/></TextStore><File><FileName/></File></Templates>";

    private CubeShortForm() {
        this._logFilePrefix = "CSMigration";
        this._logContextName = "com.sas.olapadmin.migration";
    }

    public CubeShortForm(String host, String port, String user, String password) {
        this();
        this.setConnection(host, port);
        this.setCredential(user, password);
    }

    public CubeShortForm(SessionContextInterface session) throws ServiceException, RemoteException {
        this();
        this.setConnection(session);
    }

    private static List getCubeAssociations() {
        cubeAssociations = new ArrayList();
        cubeAssociations.add("AssociatedOLAPSchema");
        cubeAssociations.add("ReachThruTables");
        cubeAssociations.add("TargetClassifierMaps");
        cubeAssociations.add("Notes");
        cubeAssociations.add("TargetTransformations");
        cubeAssociations.add("Trees");
        return cubeAssociations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        CubeShortForm shortForm = new CubeShortForm();
        int rc = 0;
        try {
            if (shortForm._help) {
                HelpFormatter help = new HelpFormatter();
                String[] exclusions = new String[]{"debug"};
                Options helpOptions = CubeShortForm.getHelpOptions((Options)shortForm._options, (String[])exclusions);
                help.printHelp(80, CubeShortForm.getUsage(help), RB.getStringResource("AbstractPromotionDriverOptions.Options.txt"), helpOptions, null);
                return;
            }
            shortForm.parse(args);
            shortForm.initialize();
            shortForm.validateSetup();
            shortForm.createShortFormFiles();
        }
        catch (ParseException e) {
            System.err.println(RB.getStringResource("BatchOLAPCubeSvrMigration.InvalidOptions.log"));
            System.err.println(e.getLocalizedMessage());
            rc = 8;
        }
        catch (Exception e) {
            String msg = Message.format((ResourceBundle)RB.getResources(), (String)"BatchOLAPCubeSvrMigration.Failed.fmt.txt", (Object)e.getLocalizedMessage());
            System.err.println(msg);
            rc = 8;
        }
        finally {
            if (shortForm != null) {
                rc |= shortForm.getReturnCode();
                String logFileName = shortForm.getLogFileName();
                if (logFileName != null) {
                    System.out.println(Message.format((ResourceBundle)RB.getResources(), (String)"BatchOLAPCubeSvrMigration.ViewLog.fmt.txt", (Object)logFileName));
                }
            }
        }
        System.exit(rc);
    }

    public void initialize() throws ServiceException, LogicalTypeException, RemoteException {
        super.initialize();
        Log.initAlreadyConfiguredLogger((String)this._logContextName, (String)this._logFileName);
        if (Workspace.getWorkspace() == null) {
            try {
                if (this._debug) {
                    String[] args = new String[]{"-serverLog", "-debug"};
                    Workspace.processCommandLineArguments((String[])args);
                }
                Workspace wksp = new Workspace(this._session);
                CMetadata foundationRepos = this._factory.getOMIUtil().getFoundationRepository();
                if (foundationRepos != null) {
                    wksp.setDefaultRepository(foundationRepos);
                }
            }
            catch (MdException e) {
                throw new ServiceException((Throwable)e);
            }
        }
    }

    public void createShortFormFiles() throws MdException, RemoteException {
        MdObjectStore store = Workspace.getMdFactory().createObjectStore();
        boolean isZOS = false;
        if (this.systemtype.equals("zos")) {
            isZOS = true;
        }
        List listOfCubes = CubeShortForm.getCubes(store);
        int size = listOfCubes.size();
        for (int i = 0; i < size; ++i) {
            Cube nextCube = (Cube)listOfCubes.get(i);
            if (nextCube == null) continue;
            this.jomaCube = nextCube;
            Workspace.getMdFactory().getOMIUtil().getMetadataAllDepths((CMetadata)this.jomaCube, null, CubeShortForm.getCubeAssociations(), READ_CUBE_TEMPLATE, 12);
            this.jomaJob = this.getJob();
            if (!isZOS) {
                String newDirectory = this.directory + "/" + this.jomaCube.getName() + ".sas";
                this.saveShortProcCode(newDirectory);
                continue;
            }
            this.saveShortProcCode(this.directory + "/Cubes.sas");
        }
        if (store != null) {
            store.dispose();
        }
    }

    protected void parse(String[] args) throws ParseException, MissingOptionException {
        this._options = new CubeShortFormOptions();
        if (args == null || args.length == 0) {
            this._help = true;
            return;
        }
        super.parse(args);
        if (this._help) {
            return;
        }
        this.directory = this._commandLine.getOptionValue("directory");
        if (this.directory.trim().length() < 0 && !this._help) {
            this._help = true;
        }
        this.systemtype = this._commandLine.getOptionValue("systemtype");
        if (this.systemtype.equals("") && !this._help) {
            this._help = true;
        }
    }

    private String generateSASCode() throws MdException, RemoteException {
        String sasCode = null;
        TextStore storedSASCode = null;
        AssociationList cubeNotes = this.jomaCube.getNotes();
        boolean found = false;
        int i = cubeNotes.size() - 1;
        while (i >= 0 & !found) {
            TextStore note = (TextStore)cubeNotes.elementAt(i);
            if (note.getName().equals(OLAP_SASCODE)) {
                storedSASCode = note;
                found = true;
            }
            --i;
        }
        sasCode = storedSASCode != null ? storedSASCode.getStoredText().trim() : " ";
        return sasCode;
    }

    private Job getJob() throws MdException, RemoteException {
        this.jomaJob = null;
        AssociationList classMap = this.jomaCube.getTargetClassifierMaps();
        TransformationStep ts = null;
        ClassifierMap loadMap = null;
        AssociationList steps = null;
        AssociationList jobs = null;
        AssociationList activities = null;
        TransformationActivity activity = null;
        if (classMap != null && !classMap.isEmpty()) {
            loadMap = (ClassifierMap)classMap.get(0);
        }
        if (loadMap != null) {
            steps = loadMap.getSteps();
        }
        if (steps != null && !steps.isEmpty()) {
            ts = (TransformationStep)steps.get(0);
        }
        if (ts != null) {
            activities = ts.getActivities();
        }
        if (activities != null && !activities.isEmpty()) {
            activity = (TransformationActivity)activities.get(0);
        }
        if (activity != null) {
            jobs = activity.getJobs();
        }
        if (jobs != null && !jobs.isEmpty()) {
            this.jomaJob = (Job)jobs.get(0);
        }
        return this.jomaJob;
    }

    private String getProcessCode(String inputProcess) throws MdException, RemoteException {
        StringBuffer sourceBuffer = new StringBuffer();
        if (this.jomaJob != null) {
            int isUserWritten = this.jomaJob.getIsUserDefined();
            if (isUserWritten == 1) {
                TextStore sourceCode = null;
                AssociationList listOfSource = this.jomaJob.getSourceCodes();
                if (!listOfSource.isEmpty()) {
                    sourceCode = (TextStore)listOfSource.get(0);
                    sourceBuffer.append(sourceCode.getStoredText());
                }
            } else {
                AssociationList textStoreList;
                Transformation correctTransformation = null;
                AssociationList listOfTS = null;
                listOfTS = inputProcess.equalsIgnoreCase(PREPROCESS) ? this.jomaJob.getTransformationSources() : this.jomaJob.getTransformationTargets();
                int size = listOfTS.size();
                for (int i = 0; i < size && correctTransformation == null; ++i) {
                    Transformation transformation = (Transformation)listOfTS.get(0);
                    String transformRole = transformation.getTransformRole();
                    if (!transformRole.equalsIgnoreCase(inputProcess)) continue;
                    correctTransformation = transformation;
                }
                if (correctTransformation != null && !(textStoreList = correctTransformation.getSourceCodes()).isEmpty()) {
                    Text text = (Text)textStoreList.get(0);
                    if (text instanceof TextStore) {
                        TextStore textStore = (TextStore)text;
                        sourceBuffer.append(textStore.getStoredText());
                    } else if (text instanceof File) {
                        File file = (File)text;
                        sourceBuffer.append(RB.getStringResource("BatchOLAPCubeSvrMigration.PostProcessFile.txt"));
                        sourceBuffer.append(this.newline).append("/* ").append(file.getFileName()).append("*/");
                    }
                }
            }
        }
        return sourceBuffer.toString();
    }

    private String generateCodeProcOlapCubeEquals() throws MdException, RemoteException {
        StringBuffer proc = new StringBuffer();
        if (this.jomaCube != null) {
            proc.append(PROCOLAP).append(this.newline);
            String pathFolder = null;
            MdOMIUtil mdUtil = Workspace.getMdFactory().getOMIUtil();
            Tree inputFolder = this.getFolder();
            if (inputFolder != null) {
                pathFolder = mdUtil.getObjectPath((MdObjectStore)inputFolder.getObjectStore(), (PrimaryType)inputFolder, false);
            }
            if (pathFolder != null && pathFolder.length() > 0) {
                proc.append(CUBEEQUALS).append("\"").append(pathFolder).append("/").append(this.jomaCube.getName()).append("\"");
            } else {
                proc.append(CUBEEQUALS).append("\"").append(this.jomaCube.getName()).append("\"");
            }
        }
        return proc.toString();
    }

    private Tree getFolder() throws MdException, RemoteException {
        Tree folder = null;
        AssociationList trees = null;
        trees = this.jomaCube.getTrees();
        if (!trees.isEmpty()) {
            folder = (Tree)trees.get(0);
        }
        return folder;
    }

    private StringBuffer generateCodeMetasrvStatement(String nameOfSchema) throws RemoteException {
        StringBuffer procOlapMetasrv = new StringBuffer();
        procOlapMetasrv.append(METASVR).append(this.newline);
        procOlapMetasrv.append(OLAPSCHEMA).append("\"").append(nameOfSchema).append("\"");
        procOlapMetasrv.append(SEMICOLON).append(this.newline);
        return procOlapMetasrv;
    }

    public boolean saveShortProcCode(String directoryFolder) throws MdException, RemoteException {
        try {
            java.io.File storeFileTo = new java.io.File(directoryFolder);
            FileWriter fileWriter = new FileWriter(storeFileTo, true);
            BufferedWriter writer = new BufferedWriter(fileWriter);
            writer.write(this.newline);
            writer.write(FIRSTCOMMENT);
            writer.write(Message.format((ResourceBundle)RB.getResources(), (String)"BatchOLAPCubeSvr.Comment.fmt.txt", (Object)this.jomaCube.getName()));
            writer.write(LASTCOMMENT);
            writer.write(this.newline);
            String sasCodeGen = this.generateSASCode();
            if (sasCodeGen.indexOf(VALIDVARNAME) < 0 && sasCodeGen.indexOf(VALIDVARNAMESMALL) < 0) {
                writer.write(VALIDVARNAMESYNTAX);
            }
            writer.write(this.newline);
            writer.write(this.getProcessCode(PREPROCESS));
            writer.write(this.newline);
            writer.write(sasCodeGen);
            writer.write(this.newline);
            writer.write(this.generateCodeFormatSearchOptions().toString());
            writer.write(this.newline);
            writer.write(this.generateLibrefCode().toString());
            writer.write(this.newline);
            writer.write(this.generateCodeProcOlapCubeEquals().toString());
            writer.write(SEMICOLON);
            writer.write(this.newline);
            writer.write(this.newline);
            writer.write(this.generateCodeMetasrvStatement(this.getAssociatedOLAPSchema()).toString());
            writer.write(this.newline);
            writer.write(this.newline);
            writer.write(RUN);
            writer.write(this.newline);
            String processCode = this.getProcessCode(POSTPROCESS);
            if (Strings.trimmedLength((String)processCode) > 0) {
                writer.write(this.getProcessCode(POSTPROCESS));
                writer.write(this.newline);
                writer.write(this.newline);
                writer.write(RUN);
            }
            writer.flush();
            writer.close();
            fileWriter.close();
        }
        catch (IOException error) {
            System.err.println(error.getLocalizedMessage());
        }
        return true;
    }

    StringBuffer generateLibrefCode() throws MdException, RemoteException {
        SASLibrary library;
        PhysicalTable drillTable;
        ArrayList<SASLibrary> listOfLibnames = new ArrayList<SASLibrary>();
        StringBuffer libraryCode = new StringBuffer();
        PhysicalTable table = this.getLoadTable();
        MdLibGenInterface libUtil = MdModelUtil.getInstance(null, null, (boolean)true, (boolean)true);
        if (table != null) {
            SASLibrary library2 = LibraryUtil.getLibrary((DataTable)table, null);
            listOfLibnames.add(library2);
            libraryCode.append(libUtil.genLibname(library2).trim());
            libraryCode.append(this.newline);
        }
        if ((drillTable = this.getDrillTable()) != null && !listOfLibnames.contains(library = LibraryUtil.getLibrary((DataTable)drillTable, null))) {
            listOfLibnames.add(library);
            libraryCode.append(libUtil.genLibname(library).trim());
            libraryCode.append(this.newline);
        }
        List dimensionTables = this.getDimensionAggregationTables();
        int size = dimensionTables.size();
        for (int i = 0; i < size; ++i) {
            PhysicalTable dimTable = (PhysicalTable)dimensionTables.get(i);
            SASLibrary sasLibrary = LibraryUtil.getLibrary((DataTable)dimTable, null);
            if (listOfLibnames.contains(sasLibrary)) continue;
            libraryCode.append(libUtil.genLibname(sasLibrary).trim());
            libraryCode.append(this.newline);
            listOfLibnames.add(sasLibrary);
        }
        return libraryCode;
    }

    public String getAssociatedOLAPSchema() throws MdException, RemoteException {
        OLAPSchema schema = this.jomaCube.getAssociatedOLAPSchema();
        if (schema != null) {
            return schema.getName();
        }
        return " ";
    }

    public List getDimensionAggregationTables() throws MdException, RemoteException {
        ArrayList<Object> listOfDimensionTables = new ArrayList<Object>();
        Object loadClassifierMap = null;
        AssociationList classifierMaps = this.jomaCube.getTargetTransformations();
        int size = classifierMaps.size();
        for (int i = 0; i < size; ++i) {
            AssociationList listOfTables;
            ClassifierMap nextCM = (ClassifierMap)classifierMaps.get(i);
            String transformRole = nextCM.getTransformRole();
            if (!transformRole.equalsIgnoreCase(STARDIM) && !transformRole.equalsIgnoreCase(STARFACT) && !transformRole.equalsIgnoreCase(AGGREGATE) || (listOfTables = nextCM.getTransformationSources()).isEmpty()) continue;
            listOfDimensionTables.add(listOfTables.elementAt(0));
        }
        return listOfDimensionTables;
    }

    public PhysicalTable getLoadTable() throws MdException, RemoteException {
        ClassifierMap loadMap;
        AssociationList sources;
        PhysicalTable loadTable = null;
        AssociationList classifierMaps = this.jomaCube.getTargetClassifierMaps();
        if (!classifierMaps.isEmpty() && !(sources = (loadMap = (ClassifierMap)classifierMaps.get(0)).getClassifierSources()).isEmpty()) {
            PhysicalTable jomaTable;
            loadTable = jomaTable = (PhysicalTable)sources.elementAt(0);
        }
        return loadTable;
    }

    public PhysicalTable getDrillTable() throws MdException, RemoteException {
        PhysicalTable drillTable = null;
        AssociationList reachthruTables = this.jomaCube.getReachThruTables();
        if (!reachthruTables.isEmpty()) {
            PhysicalTable jomaTable;
            drillTable = jomaTable = (PhysicalTable)reachthruTables.elementAt(0);
        }
        return drillTable;
    }

    public static List getCubes(MdObjectStore objectStore) {
        List cubeList = null;
        try {
            cubeList = CubeShortForm.getCMetadataList("Cube", objectStore);
        }
        catch (MdException mdException) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        return cubeList;
    }

    StringBuffer generateCodeFormatSearchOptions() throws MdException, RemoteException {
        StringBuffer sasFormats = new StringBuffer();
        String formatSearchOptions = this.getFormatSearchOptions();
        if (formatSearchOptions != null) {
            sasFormats.append(FORMATSEARCH).append(formatSearchOptions).append(");").append(this.newline).append(this.newline);
        }
        return sasFormats;
    }

    public String getFormatSearchOptions() throws MdException, RemoteException {
        TextStore storedFormatSearchOption = null;
        String formatSearchOptions = null;
        AssociationList cubeNotes = this.jomaCube.getNotes();
        boolean found = false;
        int i = 0;
        int size = cubeNotes.size();
        while (i < size & !found) {
            TextStore note = (TextStore)cubeNotes.elementAt(i);
            if (note.getName().equals("OLAPFMTSEARCH")) {
                found = true;
                storedFormatSearchOption = note;
            }
            ++i;
        }
        if (storedFormatSearchOption != null) {
            formatSearchOptions = storedFormatSearchOption.getStoredText();
        }
        return formatSearchOptions;
    }

    private static List getCMetadataList(String metadataType, MdObjectStore objectStore) throws MdException, RemoteException {
        ArrayList metadataList = new ArrayList();
        Object temp = null;
        int flags = 8456;
        String reposid = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
        List tempAll = Workspace.getMdFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)objectStore, reposid, metadataType, flags, "");
        for (int i = tempAll.size() - 1; i >= 0; --i) {
            metadataList.add(0, tempAll.get(i));
        }
        return metadataList;
    }

    private static String getUsage(HelpFormatter help) {
        String NEW_LINE = help.defaultNewLine;
        StringBuffer usage = new StringBuffer();
        usage.append("CubeShortForm -directory <directory to place files>");
        return usage.toString();
    }
}

