/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.workflow.processflow.impl;

import com.sas.lsaf.content.common.FileCreateInfo;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.workflow.processdefinition.ProcessDefinitionNotFoundException;
import com.sas.lsaf.workflow.processflow.InvalidProcessFlowStateException;
import com.sas.lsaf.workflow.processflow.ProcessFlow;
import com.sas.lsaf.workflow.processflow.ProcessFlowContextNotFoundException;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyException;
import com.sas.lsaf.workflow.processflow.ProcessFlowCopyInfo;
import com.sas.lsaf.workflow.processflow.ProcessFlowDescriptor;
import com.sas.lsaf.workflow.processflow.ProcessFlowException;
import com.sas.lsaf.workflow.processflow.ProcessFlowExistsException;
import com.sas.lsaf.workflow.processflow.ProcessFlowManifestCreateException;
import com.sas.lsaf.workflow.processflow.ProcessFlowNotFoundException;
import com.sas.lsaf.workflow.processflow.ProcessFlowQuery;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchException;
import com.sas.lsaf.workflow.processflow.ProcessFlowSearchResultItem;
import com.sas.lsaf.workflow.processflow.ProcessFlowService;
import com.sas.lsaf.workflow.processflow.impl.InternalProcessFlowService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ClientProcessFlowServiceImpl
implements ProcessFlowService {
    private ProcessFlowService processFlowService;
    private InternalProcessFlowService internalProcessFlowService;
    private String token = null;

    @Required
    public void setProcessFlowService(ProcessFlowService processFlowService) {
        this.processFlowService = processFlowService;
    }

    @Required
    public void setInternalProcessFlowService(InternalProcessFlowService internalProcessFlowService) {
        this.internalProcessFlowService = internalProcessFlowService;
    }

    @Override
    public SearchResultsInfo search(ProcessFlowQuery query) throws ProcessFlowSearchException {
        Assert.notNull((Object)query, (String)"Process flow query is required.");
        this.clearSearchResults();
        SearchResultsInfo info = this.processFlowService.search(query);
        this.token = info.getToken();
        return info;
    }

    @Override
    public List<ProcessFlowSearchResultItem> getSearchResults(int fromRow, int toRow) throws ProcessFlowSearchException {
        Assert.notNull((Object)this.token, (String)"Current search results do not exist, please call search method before calling this method.");
        return this.internalProcessFlowService.internalGetSearchResults(this.token, fromRow, toRow);
    }

    @Override
    public void clearSearchResults() {
        if (this.token == null) {
            return;
        }
        this.internalProcessFlowService.internalClearSearchResults(this.token);
        this.token = null;
    }

    @Override
    public int getSearchPageSizeLimit() {
        return this.processFlowService.getSearchPageSizeLimit();
    }

    @Override
    public Set<ProcessFlowDescriptor> getProcessFlowDescriptorsByContext(String contextId, boolean includeChildren) throws ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        return this.processFlowService.getProcessFlowDescriptorsByContext(contextId, includeChildren);
    }

    @Override
    public Set<ProcessFlowDescriptor> getAllProcessFlowDescriptors() {
        return this.processFlowService.getAllProcessFlowDescriptors();
    }

    @Override
    public Set<ProcessFlowDescriptor> getMyProcessFlowDescriptors() {
        return this.processFlowService.getMyProcessFlowDescriptors();
    }

    @Override
    public Set<ProcessFlowDescriptor> getMyProcessFlowDescriptorsByContext(String contextId, boolean includeChildren) throws ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        return this.processFlowService.getMyProcessFlowDescriptorsByContext(contextId, includeChildren);
    }

    @Override
    public boolean exists(String contextId, String processFlowName) {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        return this.processFlowService.exists(contextId, processFlowName);
    }

    @Override
    public ProcessFlow getProcessFlowByNameAndContext(String contextId, String processFlowName) throws ProcessFlowNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        return this.processFlowService.getProcessFlowByNameAndContext(contextId, processFlowName);
    }

    @Override
    public ProcessFlow getProcessFlowById(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow identifier is required.");
        return this.processFlowService.getProcessFlowById(id);
    }

    @Override
    public ProcessFlow createProcessFlow(String contextId, String processFlowName, String processDefinitionKey) throws ProcessFlowExistsException, ProcessDefinitionNotFoundException, ProcessFlowContextNotFoundException {
        Assert.hasText((String)contextId, (String)"Context id is required.");
        Assert.hasText((String)processFlowName, (String)"Process flow name is required.");
        Assert.hasText((String)processDefinitionKey, (String)"Process definition key is required.");
        return this.processFlowService.createProcessFlow(contextId, processFlowName, processDefinitionKey);
    }

    @Override
    public ProcessFlow updateProcessFlow(ProcessFlow processFlow) throws ProcessFlowNotFoundException, InvalidProcessFlowStateException, ProcessFlowException, ProcessFlowExistsException {
        Assert.notNull((Object)processFlow, (String)"Process flow is required.");
        Assert.hasText((String)processFlow.getId(), (String)"Process flow identifier is required.");
        Assert.hasText((String)processFlow.getContextId(), (String)"Process flow context identifier is required.");
        return this.processFlowService.updateProcessFlow(processFlow);
    }

    @Override
    public void deleteProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        this.processFlowService.deleteProcessFlow(id);
    }

    @Override
    public String createProcessFlowManifest(String id, FileCreateInfo manifestFileCreateInfo) throws ProcessFlowNotFoundException, ProcessFlowManifestCreateException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        Assert.notNull((Object)manifestFileCreateInfo, (String)"Process flow manifest file create information is required.");
        Assert.hasText((String)manifestFileCreateInfo.getPath(), (String)"Process flow manifest path is required.");
        return this.processFlowService.createProcessFlowManifest(id, manifestFileCreateInfo);
    }

    @Override
    public ProcessFlow activateProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        return this.processFlowService.activateProcessFlow(id);
    }

    @Override
    public ProcessFlow suspendProcessFlow(String id) throws ProcessFlowNotFoundException, ProcessFlowException {
        Assert.hasText((String)id, (String)"Process flow id is required.");
        return this.processFlowService.suspendProcessFlow(id);
    }

    @Override
    public ProcessFlow copyProcessFlow(ProcessFlowCopyInfo copyInfo) throws ProcessFlowNotFoundException, ProcessFlowExistsException, ProcessFlowCopyException {
        Assert.notNull((Object)copyInfo, (String)"Copy process flow info is required.");
        Assert.hasText((String)copyInfo.getName(), (String)"Process flow name is required to copy a process flow.");
        Assert.hasText((String)copyInfo.getSourceProcessFlowId(), (String)"Source process flow id is required to copy a process flow.");
        return this.processFlowService.copyProcessFlow(copyInfo);
    }
}

