/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.role;

import com.sas.lsaf.core.AbstractIdentifiable;
import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.security.privilege.ScopedPrivilege;
import com.sas.lsaf.svcs.core.utils.client.EqualsUtils;
import java.util.Set;

public class RoleDescriptor
extends AbstractIdentifiable {
    private static final long serialVersionUID = -8074763585648669852L;
    private final ObjectIdentity definedContext;
    private final ObjectIdentity assignedContext;
    private String name;
    private String description;
    private Set<ScopedPrivilege> privileges;

    public RoleDescriptor(String id, ObjectIdentity definedContext, ObjectIdentity assignedContext, String name, String description, Set<ScopedPrivilege> privileges) {
        super("sas:role", id);
        this.definedContext = definedContext;
        this.assignedContext = assignedContext;
        this.name = name;
        this.description = description;
        this.privileges = privileges;
    }

    public ObjectIdentity getDefinedContext() {
        return this.definedContext;
    }

    public ObjectIdentity getAssignedContext() {
        return this.assignedContext;
    }

    public boolean isInherited() {
        return EqualsUtils.notEquals((Object)this.definedContext, (Object)this.assignedContext);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Set<ScopedPrivilege> getPrivileges() {
        return this.privileges;
    }

    public void setPrivileges(Set<ScopedPrivilege> privileges) {
        this.privileges = privileges;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof RoleDescriptor)) {
            return false;
        }
        RoleDescriptor other = (RoleDescriptor)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    @Override
    public String toString() {
        return "RoleDescriptor [definedContext=" + this.definedContext + ", assignedContext=" + this.assignedContext + ", name=" + this.name + ", getId()=" + this.getId() + ", privileges=" + this.privileges.size() + "]";
    }
}

