/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.audit.impl;

import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.security.audit.AuditAction;
import com.sas.lsaf.security.audit.AuditEntry;
import com.sas.lsaf.security.audit.AuditEntryDetail;
import com.sas.lsaf.security.audit.AuditQuery;
import com.sas.lsaf.security.audit.AuditSearchException;
import com.sas.lsaf.security.audit.AuditService;
import com.sas.lsaf.security.audit.impl.InternalAuditService;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ClientAuditServiceImpl
implements AuditService {
    private AuditService auditService;
    private InternalAuditService internalAuditService;
    private String token = null;

    @Required
    public void setAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    @Required
    public void setInternalAuditService(InternalAuditService internalAuditService) {
        this.internalAuditService = internalAuditService;
    }

    @Override
    public SearchResultsInfo search(AuditQuery query) {
        Assert.notNull((Object)query, (String)"Audit query is required.");
        this.clearSearchResults();
        SearchResultsInfo info = this.auditService.search(query);
        this.token = info.getToken();
        return info;
    }

    @Override
    public List<AuditEntry> getSearchResults(int fromRow, int toRow) throws AuditSearchException {
        Assert.notNull((Object)this.token, (String)"Current search results do not exist, please call search method before calling this method.");
        return this.internalAuditService.internalGetSearchResults(this.token, fromRow, toRow);
    }

    @Override
    public List<AuditEntryDetail> getDetails(String id) {
        Assert.hasText((String)id, (String)"Audit entry identifier is required.");
        return this.auditService.getDetails(id);
    }

    @Override
    public void clearSearchResults() {
        if (this.token == null) {
            return;
        }
        this.internalAuditService.internalClearSearchResults(this.token);
        this.token = null;
    }

    @Override
    public int getSearchPageSizeLimit() {
        return this.auditService.getSearchPageSizeLimit();
    }

    @Override
    public Set<AuditAction> getAuditActions() {
        return this.auditService.getAuditActions();
    }
}

