/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.audit;

import com.sas.lsaf.core.AbstractIdentifiable;
import java.util.Date;

public class AuditEntry
extends AbstractIdentifiable {
    private static final long serialVersionUID = -1024110339509741096L;
    private final Date timestamp;
    private final String userId;
    private final String action;
    private final String sourceTypeId;
    private final String sourceId;
    private final String sourceName;
    private final String sourceLocation;
    private final Mode mode;

    public AuditEntry(String id, Date timestamp, String userId, String action, String sourceTypeId, String sourceId, String sourceName, String sourceLocation, Mode mode) {
        super("sas:auditEntry", id);
        this.timestamp = timestamp;
        this.userId = userId;
        this.action = action;
        this.sourceTypeId = sourceTypeId;
        this.sourceId = sourceId;
        this.sourceName = sourceName;
        this.sourceLocation = sourceLocation;
        this.mode = mode;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSourceTypeId() {
        return this.sourceTypeId;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getSourceLocation() {
        return this.sourceLocation;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public String getAction() {
        return this.action;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public Mode getMode() {
        return this.mode;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuditEntry)) {
            return false;
        }
        AuditEntry other = (AuditEntry)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.getTypeId() == null ? other.getTypeId() != null : !this.getTypeId().equals(other.getTypeId()));
    }

    @Override
    public String toString() {
        return "AuditEntry [userId=" + this.userId + ", action=" + this.action + ", sourceTypeId=" + this.sourceTypeId + ", sourceId=" + this.sourceId + ", sourceLocation=" + this.sourceLocation + ", sourceName=" + this.sourceName + ", timestamp=" + this.timestamp + ", getId()=" + this.getId() + "]";
    }

    public static enum Mode {
        USER,
        SYSTEM,
        ADMIN;

    }
}

