/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.security.acl;

import com.sas.lsaf.core.ObjectIdentity;
import com.sas.lsaf.security.acl.AclEntry;
import com.sas.lsaf.security.principal.Principal;
import com.sas.lsaf.security.user.UserDescriptor;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractAcl
implements Serializable {
    private static final long serialVersionUID = -3464960808313760370L;
    private Set<AclEntry> entries;
    private ObjectIdentity owningObjectIdentity;
    private UserDescriptor owner;

    public AbstractAcl(ObjectIdentity owningObjectIdentity) {
        this.owningObjectIdentity = owningObjectIdentity;
    }

    public Set<AclEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(Set<AclEntry> entries) {
        this.entries = entries;
    }

    public ObjectIdentity getOwningObjectIdentity() {
        return this.owningObjectIdentity;
    }

    public UserDescriptor getOwner() {
        return this.owner;
    }

    public void setOwner(UserDescriptor owner) {
        this.owner = owner;
    }

    public void setAce(Principal principal, AclEntry.PermissionValue adminPermission, AclEntry.PermissionValue readPermission, AclEntry.PermissionValue writePropertiesPermission, AclEntry.PermissionValue writeContentPermission, AclEntry.PermissionValue deletePermission) {
        AclEntry ace = new AclEntry();
        ace.setPrincipal(principal);
        ace.setWritePropertiesPermission(writePropertiesPermission);
        ace.setWriteContentPermission(writeContentPermission);
        ace.setDeletePermission(deletePermission);
        ace.setAdminPermission(adminPermission);
        ace.setReadPermission(readPermission);
        if (this.entries == null) {
            this.entries = new HashSet<AclEntry>();
        }
        if (this.entries.contains(ace)) {
            this.entries.remove(ace);
            this.entries.add(ace);
        } else {
            this.entries.add(ace);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.owningObjectIdentity == null ? 0 : this.owningObjectIdentity.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractAcl other = (AbstractAcl)obj;
        return !(this.owningObjectIdentity == null ? other.owningObjectIdentity != null : !this.owningObjectIdentity.equals(other.owningObjectIdentity));
    }

    public String toString() {
        return "AbstractAcl [entries=" + this.entries + ", owningObjectIdentity=" + this.owningObjectIdentity + ", owner=" + this.owner + "]";
    }
}

