/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.schedule;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.Job;
import com.sas.lsaf.execution.job.ParameterValue;
import com.sas.lsaf.schedule.Schedulable;
import java.io.Serializable;
import java.util.List;

public class ScheduleJobInfo
implements Schedulable,
Serializable {
    private static final long serialVersionUID = -4269159193168125629L;
    private String path;
    private String version;
    private SourceLocation sourceLocation;
    private List<ParameterValue> parameterValues;

    public ScheduleJobInfo() {
    }

    public ScheduleJobInfo(String path, SourceLocation sourceLocation) {
        this.path = path;
        this.sourceLocation = sourceLocation;
    }

    public ScheduleJobInfo(String path, String version, SourceLocation sourceLocation) {
        this.path = path;
        this.version = version;
        this.sourceLocation = sourceLocation;
    }

    public ScheduleJobInfo(Job job) {
        if (job != null) {
            this.path = job.getPath();
            this.sourceLocation = job.getSourceLocation();
            this.version = job.getVersion();
        }
    }

    public ScheduleJobInfo(Job job, List<ParameterValue> parameterValues) {
        if (job != null) {
            this.path = job.getPath();
            this.sourceLocation = job.getSourceLocation();
            this.version = job.getVersion();
        }
        this.parameterValues = parameterValues;
    }

    public ScheduleJobInfo(String path, String version, SourceLocation sourceLocation, List<ParameterValue> parameterValues) {
        this.path = path;
        this.version = version;
        this.sourceLocation = sourceLocation;
        this.parameterValues = parameterValues;
    }

    public void setJob(Job job) {
        if (job != null) {
            this.path = job.getPath();
            this.sourceLocation = job.getSourceLocation();
            this.version = job.getVersion();
        }
    }

    public List<ParameterValue> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List<ParameterValue> parameterValues) {
        this.parameterValues = parameterValues;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.sourceLocation == null ? 0 : this.sourceLocation.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduleJobInfo other = (ScheduleJobInfo)obj;
        if (this.parameterValues == null ? other.parameterValues != null : !this.parameterValues.equals(other.parameterValues)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.sourceLocation != other.sourceLocation) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        return "ScheduleJobInfo [path=" + this.path + ", version=" + this.version + ", sourceLocation=" + (Object)((Object)this.sourceLocation) + ", parameterValues=" + this.parameterValues + "]";
    }
}

