/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query;

import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Constraint;
import com.sas.lsaf.query.Order;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public abstract class Query
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Column> columns = new ArrayList<Column>();
    private Constraint constraint = null;
    private List<Order> order = new ArrayList<Order>();
    private boolean includeColumnNames = true;

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    public List<Order> getOrder() {
        return this.order;
    }

    public void setOrder(List<Order> order) {
        this.order = order;
    }

    public boolean isIncludeColumnNames() {
        return this.includeColumnNames;
    }

    public void setIncludeColumnNames(boolean includeColumnNames) {
        this.includeColumnNames = includeColumnNames;
    }

    public Query select(Column ... columns) {
        for (Column column : columns) {
            this.columns.add(column);
        }
        return this;
    }

    public Query select(List<Column> columns) {
        this.columns = columns;
        return this;
    }

    public Query constrain(Constraint c) {
        this.constraint = c;
        return this;
    }

    public final Query order(Column ... columns) {
        for (Column column : columns) {
            this.order.add(new Order(column));
        }
        return this;
    }

    public final Query order(Order ... orders) {
        for (Order order : orders) {
            this.order.add(order);
        }
        return this;
    }

    public final Query includeColumnNames(boolean includeColumnNames) {
        this.setIncludeColumnNames(includeColumnNames);
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [constraint=" + this.constraint + ", order=" + this.order + "]";
    }
}

