/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query;

import com.sas.lsaf.query.Column;
import java.io.Serializable;
import org.springframework.util.Assert;

public class Order
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Column column;
    private boolean ascending = false;
    private boolean caseSensitive = true;

    public Order() {
    }

    public Order(Column column) {
        this.column = column;
    }

    public Order(Column column, boolean ascending) {
        this.column = column;
        this.ascending = ascending;
    }

    public Order(Column column, boolean ascending, boolean caseSensitive) {
        this.column = column;
        this.ascending = ascending;
        this.caseSensitive = caseSensitive;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }

    public boolean isDescending() {
        return !this.ascending;
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Order ascending() {
        this.setAscending(true);
        return this;
    }

    public Order descending() {
        this.setAscending(false);
        return this;
    }

    public Order caseSensitive() {
        this.setCaseSensitive(true);
        return this;
    }

    public Order caseInsensitive() {
        this.setCaseSensitive(false);
        return this;
    }

    public Order column(Column column) {
        this.setColumn(column);
        return this;
    }

    public String toString() {
        return "Order [column=" + this.column + ", ascending=" + this.ascending + ", caseSensitive=" + this.caseSensitive + "]";
    }

    public static Order order(Column column, boolean ascending) {
        Assert.notNull((Object)column, (String)"Column is required.");
        return new Order(column, ascending);
    }

    public static Order order(Column column, boolean ascending, boolean caseSensitive) {
        Assert.notNull((Object)column, (String)"Column is required.");
        return new Order(column, ascending, caseSensitive);
    }

    public static Order ascending(Column column) {
        return new Order(column, true);
    }

    public static Order ascending(Column column, boolean caseSensitive) {
        return new Order(column, true, caseSensitive);
    }

    public static Order descending(Column column) {
        return new Order(column, false);
    }

    public static Order descending(Column column, boolean caseSensitive) {
        return new Order(column, false, caseSensitive);
    }
}

