/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query;

import com.sas.lsaf.query.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Condition
implements Constraint {
    private static final long serialVersionUID = 2694753998950229037L;
    private List<Constraint> constraints;
    private Operator operator;

    public Condition() {
        this.constraints = new ArrayList<Constraint>();
    }

    public Condition(Operator operator) {
        this.operator = operator;
        this.constraints = new ArrayList<Constraint>();
    }

    public Condition(Operator operator, List<Constraint> constraints) {
        this.operator = operator;
        this.constraints = constraints;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public List<Constraint> getConstraints() {
        return this.constraints;
    }

    public void setConstraints(List<Constraint> constraints) {
        this.constraints = constraints;
    }

    public Condition operator(Operator o) {
        this.setOperator(o);
        return this;
    }

    public Condition constraints(List<Constraint> cs) {
        this.setConstraints(cs);
        return this;
    }

    public Condition addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
        return this;
    }

    public String toString() {
        return "Condition [constraints=" + this.constraints + ", operator=" + (Object)((Object)this.operator) + "]";
    }

    public static Condition and(List<Constraint> constraints) {
        return new Condition(Operator.AND, constraints);
    }

    public static Condition and(Constraint ... constraints) {
        return new Condition(Operator.AND, Arrays.asList(constraints));
    }

    public static Condition or(List<Constraint> constraints) {
        return new Condition(Operator.OR, constraints);
    }

    public static Condition or(Constraint ... constraints) {
        return new Condition(Operator.OR, Arrays.asList(constraints));
    }

    public static enum Operator {
        AND,
        OR;

    }
}

