/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.query;

import com.sas.lsaf.query.Column;
import com.sas.lsaf.query.Constraint;
import java.io.Serializable;
import org.springframework.util.Assert;

public class Comparison
implements Constraint {
    private static final long serialVersionUID = 2563122955299720874L;
    private Column column;
    private Operator operator;
    private Serializable value;
    private boolean caseSensitive = true;

    public Comparison(Column column, Operator operator, Serializable value) {
        this.column = column;
        this.operator = operator;
        this.value = value;
    }

    public Comparison(Column column, Operator operator, Serializable value, boolean caseSensitive) {
        this.column = column;
        this.operator = operator;
        this.value = value;
        this.caseSensitive = caseSensitive;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public Serializable getValue() {
        return this.value;
    }

    public void setValue(Serializable value) {
        this.value = value;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Comparison caseSensitive() {
        this.setCaseSensitive(true);
        return this;
    }

    public Comparison caseInsensitive() {
        this.setCaseSensitive(false);
        return this;
    }

    public Comparison column(Column column) {
        this.setColumn(column);
        return this;
    }

    public Comparison operator(Operator o) {
        this.setOperator(o);
        return this;
    }

    public Comparison value(Serializable v) {
        this.setValue(v);
        return this;
    }

    public String toString() {
        return "Comparison [column=" + this.column + ", operator=" + (Object)((Object)this.operator) + ", value=" + this.value + ", caseSensitive=" + this.caseSensitive + "]";
    }

    public static Comparison comparison(Column column, Operator operator, Serializable value) {
        Assert.notNull((Object)column, (String)"Column is required.");
        return new Comparison(column, operator, value);
    }

    public static Comparison comparison(Column column, Operator operator, Serializable value, boolean caseSensitive) {
        Assert.notNull((Object)column, (String)"Column is required.");
        return new Comparison(column, operator, value, caseSensitive);
    }

    public static Comparison equal(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.EQUAL, value);
    }

    public static Comparison equal(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.EQUAL, value, caseSensitive);
    }

    public static Comparison notEqual(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.NOT_EQUAL, value);
    }

    public static Comparison notEqual(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.NOT_EQUAL, value, caseSensitive);
    }

    public static Comparison greaterThan(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.GREATER_THAN, value);
    }

    public static Comparison greaterThan(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.GREATER_THAN, value, caseSensitive);
    }

    public static Comparison greaterThanOrEqual(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.GREATER_THAN_OR_EQUAL, value);
    }

    public static Comparison greaterThanOrEqual(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.GREATER_THAN_OR_EQUAL, value, caseSensitive);
    }

    public static Comparison lessThan(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.LESS_THAN, value);
    }

    public static Comparison lessThan(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.LESS_THAN, value, caseSensitive);
    }

    public static Comparison lessThanOrEqual(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.LESS_THAN_OR_EQUAL, value);
    }

    public static Comparison lessThanOrEqual(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.LESS_THAN_OR_EQUAL, value, caseSensitive);
    }

    public static Comparison like(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.LIKE, value);
    }

    public static Comparison like(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.LIKE, value, caseSensitive);
    }

    public static Comparison notLike(Column column, Serializable value) {
        return Comparison.comparison(column, Operator.NOT_LIKE, value);
    }

    public static Comparison notLike(Column column, Serializable value, boolean caseSensitive) {
        return Comparison.comparison(column, Operator.NOT_LIKE, value, caseSensitive);
    }

    public static enum Operator {
        EQUAL,
        NOT_EQUAL,
        LESS_THAN,
        GREATER_THAN,
        LESS_THAN_OR_EQUAL,
        GREATER_THAN_OR_EQUAL,
        LIKE,
        NOT_LIKE;

    }
}

