/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.session;

import com.sas.lsaf.core.AbstractIdentifiable;
import java.util.Date;

public class Session
extends AbstractIdentifiable {
    private static final long serialVersionUID = 2004146947301837537L;
    private Date started;
    private Date ended;
    private SessionType type = null;
    private SessionState state = null;
    private SessionEngine engine = SessionEngine.SAS;
    private String userId;
    private String submissionLabel;
    private int clientId = 0;
    private long logErrors;
    private long logWarnings;

    public Session(String typeId, String id, Date started, Date ended, SessionType type, SessionState state, String userId, String submissionLabel, int clientId) {
        super(typeId, id);
        this.started = started;
        this.ended = ended;
        this.type = type;
        this.state = state;
        this.userId = userId;
        this.submissionLabel = submissionLabel;
        this.clientId = clientId;
    }

    public Session(String typeId, String id, Date started, Date ended, SessionType type, SessionState state, String userId, String submissionLabel, int clientId, SessionEngine engine, long logErrors, long logWarnings) {
        super(typeId, id);
        this.started = started;
        this.ended = ended;
        this.type = type;
        this.state = state;
        this.userId = userId;
        this.submissionLabel = submissionLabel;
        this.clientId = clientId;
        this.engine = engine;
        this.logErrors = logErrors;
        this.logWarnings = logWarnings;
    }

    public Date getDateStarted() {
        return this.started;
    }

    public Date getDateEnded() {
        return this.ended;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getSubmissionLabel() {
        return this.submissionLabel;
    }

    public SessionEngine getEngine() {
        return this.engine;
    }

    public long getLogErrors() {
        return this.logErrors;
    }

    public long getLogWarnings() {
        return this.logWarnings;
    }

    public SessionType getType() {
        return this.type;
    }

    public SessionState getState() {
        return this.state;
    }

    public int getClientId() {
        return this.clientId;
    }

    @Override
    public String toString() {
        return "Session [engine=" + (Object)((Object)this.engine) + ", type=" + (Object)((Object)this.type) + ", state=" + (Object)((Object)this.state) + ", userId=" + this.userId + ", submissionLabel=" + this.submissionLabel + ", started=" + this.started + ", ended=" + this.ended + ", clientId=" + this.clientId + ", logErrors=" + this.logErrors + ", logWarnings=" + this.logWarnings + "]";
    }

    public static enum SessionEngine {
        SAS,
        R,
        COMPOSITE;

    }

    public static enum SessionState {
        IDLE,
        ACTIVE,
        ENDED,
        ENDING,
        BROKEN;

    }

    public static enum SessionType {
        INTERACTIVE,
        TEST_JOB,
        WORKSPACE_JOB,
        PUBLISHED_JOB,
        SYSTEM,
        UNKNOWN;

    }
}

