/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job;

import com.sas.lsaf.execution.job.ManifestRepositoryFile;
import com.sas.lsaf.execution.job.ManifestWorkspaceFile;
import java.io.Serializable;
import java.util.Date;

public abstract class ManifestFile
implements Serializable {
    private static final long serialVersionUID = 3569146723690133229L;
    private final String path;
    private final String name;
    private Date lastModified;
    private Long size;

    public ManifestFile(String path, String name, Date lastModified, Long size) {
        this.path = path;
        this.name = name;
        this.lastModified = lastModified;
        this.size = size;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public Long getSize() {
        return this.size;
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public boolean isRepositoryFile() {
        return this instanceof ManifestRepositoryFile;
    }

    public boolean isWorkspaceFile() {
        return this instanceof ManifestWorkspaceFile;
    }

    public String getId() {
        if (this instanceof ManifestRepositoryFile) {
            return ((ManifestRepositoryFile)this).getId();
        }
        return null;
    }

    public String getVersion() {
        if (this instanceof ManifestRepositoryFile) {
            return ((ManifestRepositoryFile)this).getVersion();
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lastModified == null ? 0 : this.lastModified.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ManifestFile other = (ManifestFile)obj;
        if (this.lastModified == null ? other.lastModified != null : !this.lastModified.equals(other.lastModified)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return !(this.size == null ? other.size != null : !this.size.equals(other.size));
    }

    public String toString() {
        return "ManifestFile [path=" + this.path + ", name=" + this.name + ", lastModified=" + this.lastModified + ", size=" + this.size + "]";
    }
}

