/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job;

import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobSubmission;
import com.sas.lsaf.execution.job.ManifestExternalReference;
import com.sas.lsaf.execution.job.ManifestFile;
import com.sas.lsaf.execution.job.ManifestInput;
import com.sas.lsaf.execution.job.ManifestJob;
import com.sas.lsaf.execution.job.ManifestMetrics;
import com.sas.lsaf.execution.job.ManifestOutput;
import com.sas.lsaf.execution.job.ManifestProgram;
import com.sas.lsaf.execution.job.ManifestSystemFile;
import com.sas.lsaf.execution.job.OutputFileSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Manifest
implements Serializable {
    private static final long serialVersionUID = -4046673104072893851L;
    private final ManifestFile manifest;
    private final ManifestJob job;
    private final JobSubmission jobSubmission;
    private final List<ManifestProgram> programs;
    private final List<ManifestInput> inputs;
    private final List<ManifestExternalReference> externalInputs = new ArrayList<ManifestExternalReference>();
    private final List<ManifestOutput> outputs;
    private final List<ManifestExternalReference> externalOutputs = new ArrayList<ManifestExternalReference>();
    private final OutputFileSpec outputFileSpec;
    private final List<JobParameter> parameters;
    private final ManifestType manifestType;
    private final List<ManifestSystemFile> logs = new ArrayList<ManifestSystemFile>();
    private final List<ManifestSystemFile> results = new ArrayList<ManifestSystemFile>();
    private final ManifestMetrics manifestMetrics;
    private final Long totalExecutionTime;

    public Manifest(ManifestFile manifest, ManifestJob job, JobSubmission jobSubmission, List<ManifestProgram> programs, List<ManifestInput> inputs, List<ManifestOutput> outputs, OutputFileSpec outputFileSpec, List<JobParameter> parameters, ManifestType manifestType, List<ManifestSystemFile> logs, List<ManifestSystemFile> results, ManifestMetrics manifestMetrics, Long totalExecutionTime, List<ManifestExternalReference> externalInputs, List<ManifestExternalReference> externalOutputs) {
        this.manifest = manifest;
        this.job = job;
        this.jobSubmission = jobSubmission;
        this.programs = programs;
        this.inputs = inputs;
        this.outputs = outputs;
        this.outputFileSpec = outputFileSpec;
        this.parameters = parameters;
        this.manifestType = manifestType;
        this.logs.addAll(logs);
        this.results.addAll(results);
        this.manifestMetrics = manifestMetrics;
        this.totalExecutionTime = totalExecutionTime;
        this.externalInputs.addAll(externalInputs);
        this.externalOutputs.addAll(externalOutputs);
    }

    public JobSubmission getJobSubmission() {
        return this.jobSubmission;
    }

    public List<ManifestInput> getInputs() {
        return this.inputs;
    }

    public List<ManifestExternalReference> getExternalInputs() {
        return this.externalInputs;
    }

    public List<ManifestOutput> getOutputs() {
        return this.outputs;
    }

    public List<ManifestExternalReference> getExternalOutputs() {
        return this.externalOutputs;
    }

    public List<JobParameter> getParameters() {
        return this.parameters;
    }

    public OutputFileSpec getOutputFileSpec() {
        return this.outputFileSpec;
    }

    public ManifestType getManifestType() {
        return this.manifestType;
    }

    public List<ManifestProgram> getPrograms() {
        return this.programs;
    }

    public List<ManifestSystemFile> getLogs() {
        return this.logs;
    }

    public List<ManifestSystemFile> getResults() {
        return this.results;
    }

    public ManifestFile getManifest() {
        return this.manifest;
    }

    public ManifestJob getJob() {
        return this.job;
    }

    public ManifestMetrics getManifestMetrics() {
        return this.manifestMetrics;
    }

    public Long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String toString() {
        return "Manifest [job=" + this.getJob() + ", jobSubmission=" + this.jobSubmission + ", programs=" + this.programs + "]";
    }

    public static enum ManifestType {
        WORKSPACE,
        PUBLISHED,
        TEST;

    }
}

