/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.execution.job;

import com.sas.lsaf.core.SourceLocation;
import com.sas.lsaf.execution.job.JobInputFile;
import com.sas.lsaf.execution.job.JobInputFolder;
import com.sas.lsaf.execution.job.JobParameter;
import com.sas.lsaf.execution.job.JobProgram;
import com.sas.lsaf.execution.job.JobPublishCheckin;
import com.sas.lsaf.execution.job.JobPublishCheckinLocation;
import com.sas.lsaf.execution.job.JobPublishSetup;
import com.sas.lsaf.execution.job.JobPublishSetupFile;
import com.sas.lsaf.execution.job.JobPublishSetupFolder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Job
implements Serializable {
    private static final long serialVersionUID = 8378836682359675565L;
    private String path;
    private String version;
    private SourceLocation sourceLocation = SourceLocation.WORKSPACE;
    private String description = null;
    private List<JobProgram> programs = new ArrayList<JobProgram>();
    private JobPublishSetup publishSetup = new JobPublishSetup();
    private JobPublishCheckin publishCheckin = new JobPublishCheckin();
    private String logsLocation = null;
    private String resultsLocation = null;
    private String manifestLocation = null;
    private List<JobParameter> parameters = new ArrayList<JobParameter>();
    private String owner;
    private boolean runAsOwner = false;

    public Job() {
    }

    public Job(String path) {
        this();
        this.path = path;
    }

    public Job(String path, String version) {
        this();
        this.path = path;
        this.version = version;
    }

    public Job(String path, String version, SourceLocation sourceLocation) {
        this();
        this.path = path;
        this.version = version;
        this.sourceLocation = sourceLocation;
    }

    public Job(String path, String version, String owner, boolean runAsOwner) {
        this();
        this.path = path;
        this.version = version;
        this.owner = owner;
        this.runAsOwner = runAsOwner;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getVersion() {
        return this.version;
    }

    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public void setSourceLocation(SourceLocation sourceLocation) {
        this.sourceLocation = sourceLocation;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<JobProgram> getPrograms() {
        return this.programs;
    }

    public void setPrograms(List<JobProgram> programs) {
        this.programs = programs;
    }

    public JobPublishSetup getPublishSetup() {
        return this.publishSetup;
    }

    public void setPublishSetup(JobPublishSetup publishSetup) {
        this.publishSetup = publishSetup;
    }

    public JobPublishCheckin getPublishCheckin() {
        return this.publishCheckin;
    }

    public void setPublishCheckin(JobPublishCheckin publishCheckin) {
        this.publishCheckin = publishCheckin;
    }

    public String getLogsLocation() {
        return this.logsLocation;
    }

    public void setLogsLocation(String logsLocation) {
        this.logsLocation = logsLocation;
    }

    public String getResultsLocation() {
        return this.resultsLocation;
    }

    public void setResultsLocation(String resultsLocation) {
        this.resultsLocation = resultsLocation;
    }

    public String getManifestLocation() {
        return this.manifestLocation;
    }

    public void setManifestLocation(String manifestLocation) {
        this.manifestLocation = manifestLocation;
    }

    public List<JobParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<JobParameter> parameters) {
        this.parameters = parameters;
    }

    public String getOwner() {
        return this.owner;
    }

    public boolean isRunAsOwner() {
        return this.runAsOwner;
    }

    public void addProgram(String path) {
        this.programs.add(new JobProgram(path));
    }

    public void addProgram(String path, String version) {
        this.programs.add(new JobProgram(path, version));
    }

    public void addFileParameter(String name, String label, String path) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.FILE, path == null ? null : new JobInputFile(path)));
    }

    public void addFileParameter(String name, String label, String path, String version) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.FILE, path == null ? null : new JobInputFile(path, version)));
    }

    public void addFolderParameter(String name, String label, String path) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.FOLDER, path == null ? null : new JobInputFolder(path)));
    }

    public void addFolderParameter(String name, String label, String path, boolean includeSubfolders) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.FOLDER, path == null ? null : new JobInputFolder(path, includeSubfolders)));
    }

    public void addCharacterParameter(String name, String label, String value) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.CHARACTER, (Serializable)((Object)value)));
    }

    public void addCharacterMaskedParameter(String name, String label, String value) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.CHARACTER_MASKED, (Serializable)((Object)value)));
    }

    public void addNumericParameter(String name, String label, String value) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.NUMERIC, (Serializable)((Object)value)));
    }

    public void addDateParameter(String name, String label, Date value) {
        this.parameters.add(new JobParameter(name, label, JobParameter.ParameterType.DATE, value));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        result = 31 * result + (this.sourceLocation == null ? 0 : this.sourceLocation.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Job other = (Job)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        if (this.sourceLocation != other.sourceLocation) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\r\nJob [path=" + this.path);
        sb.append("\r\n    version=" + this.version);
        sb.append("\r\n    sourceLocation=" + (Object)((Object)this.sourceLocation));
        sb.append("\r\n    logs=" + this.logsLocation);
        sb.append("\r\n    results=" + this.resultsLocation);
        sb.append("\r\n    manifest=" + this.manifestLocation);
        sb.append("\r\n  Programs [");
        if (this.programs != null) {
            for (JobProgram program : this.programs) {
                sb.append("\r\n    " + program);
            }
        }
        sb.append("]");
        sb.append("\r\n  Parameters [");
        if (this.parameters != null) {
            for (JobParameter parameter : this.parameters) {
                sb.append("\r\n    " + parameter);
            }
        }
        sb.append("]");
        sb.append("\r\n  Publish Setup [");
        if (this.publishSetup != null) {
            sb.append("\r\n    Files [");
            for (JobPublishSetupFile file : this.publishSetup.getFiles()) {
                sb.append("\r\n    " + file);
            }
            sb.append("]");
            sb.append("\r\n    Folders [");
            for (JobPublishSetupFolder folder : this.publishSetup.getFolders()) {
                sb.append("\r\n    " + folder);
            }
            sb.append("]");
        }
        sb.append("]");
        sb.append("\r\n  Publish Checkin [");
        if (this.publishCheckin != null) {
            sb.append("\r\n    enableVersioningForNewFiles=" + this.publishCheckin.isEnableVersioningForNewFiles());
            sb.append("\r\n    versionType=" + (Object)((Object)this.publishCheckin.getVersionType()));
            sb.append("\r\n    customVersion=" + this.publishCheckin.getCustomVersion());
            sb.append("\r\n    Locations [");
            for (JobPublishCheckinLocation location : this.publishCheckin.getLocations()) {
                sb.append("\r\n    " + location);
            }
            sb.append("]");
        }
        sb.append("]\r\n]");
        return sb.toString();
    }
}

