/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.utils.impl;

import com.sas.lsaf.core.SystemException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collection;
import org.springframework.util.Assert;

public class UriUtils {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String SCHEME_WORKSPACE = "work";
    private static final String SCHEME_REPOSITORY = "sdd";
    private static final String PARAMETER_VERSION = "version";
    private static final String PARAMETER_URI_DELIMITER = "\\?";

    private UriUtils() {
    }

    private static String toUri(String scheme, String path, String version) {
        Assert.hasText((String)path, (String)"Path is required.");
        String query = null;
        if (version != null && version.length() > 0) {
            query = "version=" + version;
        }
        try {
            URI uri = new URI(scheme, null, null, -1, "//" + path, query, null);
            String uriString = uri.toASCIIString();
            if (uriString.endsWith(":/")) {
                return uriString + "//";
            }
            return uriString;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Path is malformed or contains illegal characters:  " + path);
        }
    }

    private static String toUris(String scheme, Collection<String> paths) {
        StringBuffer uris = new StringBuffer();
        for (String path : paths) {
            uris.append(UriUtils.toUri(scheme, path, null));
            uris.append(PARAMETER_URI_DELIMITER);
        }
        return uris.substring(0, uris.length() - PARAMETER_URI_DELIMITER.length());
    }

    public static String toWorkspaceUri(String path) {
        return UriUtils.toUri(SCHEME_WORKSPACE, path, null);
    }

    public static String toRepositoryUri(String path) {
        return UriUtils.toUri(SCHEME_REPOSITORY, path, null);
    }

    public static String toRepositoryUri(String path, String version) {
        return UriUtils.toUri(SCHEME_REPOSITORY, path, version);
    }

    public static String toRepositoryUris(Collection<String> paths) {
        return UriUtils.toUris(SCHEME_REPOSITORY, paths);
    }

    public static String toWorkspaceUris(Collection<String> paths) {
        return UriUtils.toUris(SCHEME_WORKSPACE, paths);
    }

    public static String encode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLEncoder.encode(s, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException("URI encoding is unsupported.", e);
        }
    }

    public static String decode(String s) {
        if (s == null) {
            return s;
        }
        try {
            return URLDecoder.decode(s, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException("URI encoding is unsupported.", e);
        }
    }

    public static String encodePath(String path) {
        if (path == null) {
            return path;
        }
        return org.springframework.web.util.UriUtils.encodePath((String)path, (String)DEFAULT_ENCODING);
    }
}

