/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.utils.impl;

import com.sas.lsaf.core.IllegalPathException;
import java.io.File;
import java.io.IOException;
import java.net.URI;

public class PathUtils {
    public static final String SEPARATOR = "/";
    public static final String SLASHDOT = "/.";

    public static String getParentPath(String path) {
        if (path == null) {
            return null;
        }
        int index = path.lastIndexOf(SEPARATOR);
        String parent = null;
        parent = path.length() == 1 || index < 0 ? "" : (index == 0 ? SEPARATOR : path.substring(0, index));
        if (parent.endsWith(".")) {
            return parent + SEPARATOR;
        }
        return parent;
    }

    public static String getName(String path) {
        if (path == null) {
            return null;
        }
        if (path.equals(SEPARATOR)) {
            return "";
        }
        int index = path.lastIndexOf(SEPARATOR);
        if (index < 0) {
            return "";
        }
        return path.substring(index + 1);
    }

    public static String makePathFromURIString(String uriString) {
        if (uriString.indexOf(SEPARATOR) == -1) {
            return SEPARATOR;
        }
        URI tempURI = URI.create(uriString);
        return tempURI.getPath();
    }

    public static void assertVersionLabelIsLegal(String versionLabel) {
        if (versionLabel == null || versionLabel.length() < 1) {
            throw new IllegalArgumentException("Version label must be non-null and have a value.");
        }
    }

    public static File assertFileIsReadable(String localFilePath) throws IOException {
        File file = new File(localFilePath);
        if (file.exists() && file.isDirectory()) {
            throw new IllegalPathException("Local file path must be a path to a file, not a folder.");
        }
        if (!file.canRead()) {
            throw new IOException("Local file path cannot be read.");
        }
        return file;
    }

    public static File assertFileIsWritable(String localFilePath) throws IOException {
        File file = new File(localFilePath);
        return PathUtils.assertFileIsWritable(file);
    }

    public static File assertFileIsWritable(File file) throws IOException {
        if (file.exists() && file.isDirectory()) {
            throw new IllegalPathException("Local file path must be a path to a file, not a folder.");
        }
        if (file.exists()) {
            if (!file.canWrite()) {
                throw new IOException("Local file path exists but is not writeable.");
            }
        } else {
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IOException("Local file parent path cannot be created.");
            }
            if (!file.createNewFile()) {
                throw new IOException("Local file path cannot be created.");
            }
        }
        return file;
    }

    public static void validatePath(String path) {
        if (path.contains(SLASHDOT)) {
            throw new IllegalPathException("Hidden paths are not supported.");
        }
        if (!path.startsWith(SEPARATOR)) {
            throw new IllegalPathException("Path must start with a slash.");
        }
    }
}

