/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.utils.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.Assert;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> Set<T> asSet(List<T> list) {
        Assert.notNull(list, (String)"List must be non-null");
        HashSet<T> s = new HashSet<T>(list);
        return s;
    }

    @SafeVarargs
    public static <T> Set<T> asSet(T ... args) {
        Assert.notNull(args, (String)"Arguments must be non-null");
        HashSet<T> s = new HashSet<T>(args.length);
        for (T element : args) {
            s.add(element);
        }
        return s;
    }
}

