/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.core.type;

import com.sas.lsaf.core.type.AttributeDefinition;
import com.sas.lsaf.core.type.TypeDescriptor;
import java.util.List;

public class Type
extends TypeDescriptor {
    private static final long serialVersionUID = 5788072328120593893L;
    private final long revision;
    private final List<AttributeDefinition> attributeDefinitions;
    private final List<Capability> capabilities;
    private final List<String> allowableChildTypes;

    public Type(String id, String name, String description, boolean contextType, boolean folderType, boolean sharedFolderType, boolean fileType, List<AttributeDefinition> attributeDefinitions, List<Capability> capabilities, List<String> allowableChildTypes, long revision) {
        super(id, name, description, contextType, folderType, sharedFolderType, fileType);
        this.attributeDefinitions = attributeDefinitions;
        this.capabilities = capabilities;
        this.allowableChildTypes = allowableChildTypes;
        this.revision = revision;
    }

    public long getRevision() {
        return this.revision;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public AttributeDefinition getAttributeDefinitionById(String id) {
        for (AttributeDefinition ad : this.attributeDefinitions) {
            if (!ad.getId().equals(id)) continue;
            return ad;
        }
        return null;
    }

    public AttributeDefinition getAttributeDefinitionByName(String name) {
        for (AttributeDefinition ad : this.attributeDefinitions) {
            if (!ad.getName().equals(name)) continue;
            return ad;
        }
        return null;
    }

    public List<Capability> getCapabilities() {
        return this.capabilities;
    }

    public List<String> getAllowableChildTypes() {
        return this.allowableChildTypes;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Type [id=" + this.getId() + ", name=" + this.getName() + ", attributes=" + this.attributeDefinitions.size() + "]";
    }

    public static enum Capability {
        TOP,
        MEMBERSHIP,
        WORKFLOW,
        STATE,
        STUDY,
        FILES;

    }
}

