/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.workspace.impl;

import com.sas.lsaf.content.impl.ClientFileStreamingHelper;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.workspace.WorkspaceFile;
import com.sas.lsaf.content.workspace.WorkspaceFolder;
import com.sas.lsaf.content.workspace.WorkspaceItem;
import com.sas.lsaf.content.workspace.WorkspaceItemCopyException;
import com.sas.lsaf.content.workspace.WorkspaceItemDeleteException;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.content.workspace.WorkspaceItemMoveException;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.content.workspace.WorkspaceMarkForAddException;
import com.sas.lsaf.content.workspace.WorkspaceService;
import com.sas.lsaf.content.workspace.impl.InternalWorkspaceService;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;

public class ClientWorkspaceServiceImpl
implements WorkspaceService,
InternalWorkspaceService {
    private WorkspaceService workspaceService;
    private InternalWorkspaceService internalWorkspaceService;
    private ClientFileStreamingHelper clientFileStreamingHelper;

    @Required
    public void setWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    @Required
    public void setInternalWorkspaceService(InternalWorkspaceService internalWorkspaceService) {
        this.internalWorkspaceService = internalWorkspaceService;
    }

    @Required
    public void setClientFileStreamingHelper(ClientFileStreamingHelper clientFileStreamingHelper) {
        this.clientFileStreamingHelper = clientFileStreamingHelper;
    }

    @Override
    public WorkspaceFolder createFolder(String path, boolean createParentFolders) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.workspaceService.createFolder(path, createParentFolders);
    }

    @Override
    public WorkspaceFile createFile(String path, String localFilePath, boolean createParentFolders) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.createWorkspaceFile(path, localFilePath, createParentFolders);
    }

    @Override
    public WorkspaceItem rename(String path, String name) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)name, (String)"Name is required.");
        return this.workspaceService.rename(path, name);
    }

    @Override
    public WorkspaceItem move(String sourcePath, String destinationPath) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, WorkspaceItemMoveException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        return this.workspaceService.move(sourcePath, destinationPath);
    }

    @Override
    public WorkspaceItem copy(String sourcePath, String destinationPath) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, WorkspaceItemCopyException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        return this.workspaceService.copy(sourcePath, destinationPath);
    }

    @Override
    public void delete(String path) throws WorkspaceItemNotFoundException, WorkspaceItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.workspaceService.delete(path);
    }

    @Override
    public void downloadFile(String path, String localFilePath) throws WorkspaceItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.clientFileStreamingHelper.downloadWorkspaceFile(path, localFilePath);
    }

    @Override
    public boolean exists(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.workspaceService.exists(path);
    }

    @Override
    public WorkspaceItem getItem(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.workspaceService.getItem(path);
    }

    @Override
    public List<WorkspaceItem> getChildren(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.workspaceService.getChildren(path);
    }

    @Override
    public WorkspaceFile updateFileContents(String path, String localFilePath) throws WorkspaceItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.updateWorkspaceFileContents(path, localFilePath);
    }

    @Override
    public void markForAdd(String path) throws WorkspaceMarkForAddException, WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.workspaceService.markForAdd(path);
    }

    @Override
    public String batchPrepareUpload(Set<String> paths) {
        return this.internalWorkspaceService.batchPrepareUpload(paths);
    }

    @Override
    public String batchPrepareUploadAndExpand(String path) {
        return this.internalWorkspaceService.batchPrepareUploadAndExpand(path);
    }

    @Override
    public SynchronizationInfo.CheckoutStatus getCheckoutStatus(String path) throws WorkspaceItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.workspaceService.getCheckoutStatus(path);
    }
}

