/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.workspace.impl;

import com.sas.lsaf.content.impl.ClientFileStreamingHelper;
import com.sas.lsaf.content.workspace.BatchWorkspaceService;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.core.action.ActionStatus;
import java.io.IOException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ClientBatchWorkspaceServiceImpl
implements BatchWorkspaceService {
    private ClientFileStreamingHelper clientFileStreamingHelper;

    @Required
    public void setClientFileStreamingHelper(ClientFileStreamingHelper clientFileStreamingHelper) {
        this.clientFileStreamingHelper = clientFileStreamingHelper;
    }

    @Override
    public ActionStatus uploadAndExpand(String parentPath, String localFilePath, boolean createParentFolders) {
        Assert.hasText((String)parentPath, (String)"Parent path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.uploadAndExpandInWorkspace(parentPath, localFilePath, createParentFolders);
    }

    @Override
    public void downloadAsZip(Set<String> paths, String localFilePath, boolean overwrite) throws WorkspaceItemNotFoundException, IOException {
        Assert.notEmpty(paths, (String)"Paths are required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.clientFileStreamingHelper.downloadAsZipFromWorkspace(paths, localFilePath, overwrite);
    }
}

