/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.impl;

import com.sas.lsaf.content.impl.ClientFileStreamingHelper;
import com.sas.lsaf.content.repository.CheckedOutFilesQuery;
import com.sas.lsaf.content.repository.CheckedOutFilesSearchException;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryFileVersionInfo;
import com.sas.lsaf.content.repository.RepositoryFolder;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.RepositoryItemCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemCopyException;
import com.sas.lsaf.content.repository.RepositoryItemDeleteException;
import com.sas.lsaf.content.repository.RepositoryItemExistsException;
import com.sas.lsaf.content.repository.RepositoryItemLockException;
import com.sas.lsaf.content.repository.RepositoryItemMoveException;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryItemUndoCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemUnlockException;
import com.sas.lsaf.content.repository.RepositoryItemUpdateException;
import com.sas.lsaf.content.repository.RepositoryItemVersioningException;
import com.sas.lsaf.content.repository.RepositorySearchException;
import com.sas.lsaf.content.repository.RepositorySearchResults;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.RepositorySharedFolder;
import com.sas.lsaf.content.repository.RepositoryStateChangeResult;
import com.sas.lsaf.content.repository.SearchQuery;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.content.repository.impl.InternalRepositoryService;
import com.sas.lsaf.core.SearchResultsInfo;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ClientRepositoryServiceImpl
implements RepositoryService,
InternalRepositoryService {
    private RepositoryService repositoryService;
    private InternalRepositoryService internalRepositoryService;
    private ClientFileStreamingHelper clientFileStreamingHelper;
    private String token = null;

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    @Required
    public void setClientFileStreamingHelper(ClientFileStreamingHelper clientFileStreamingHelper) {
        this.clientFileStreamingHelper = clientFileStreamingHelper;
    }

    @Override
    public RepositoryContext createContext(String path, String typeId) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)typeId, (String)"Type identifier is required.");
        return this.repositoryService.createContext(path, typeId);
    }

    @Override
    public RepositoryFolder createFolder(String path, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.createFolder(path, createParentFolders);
    }

    @Override
    public RepositorySharedFolder createSharedFolder(String path) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.createSharedFolder(path);
    }

    @Override
    public RepositoryFile createFile(String path, String localFilePath, String comment, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.createRepositoryFile(path, localFilePath, comment, createParentFolders);
    }

    @Override
    public RepositoryFile createVersionedFile(String path, String localFilePath, String comment, String startingVersion, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        String version = startingVersion;
        if (version == null || version.trim().isEmpty()) {
            version = "1.0";
        }
        return this.clientFileStreamingHelper.createRepositoryVersionedFile(path, localFilePath, version, comment, createParentFolders);
    }

    @Override
    public RepositoryItem updateItem(RepositoryItem item) throws RepositoryItemNotFoundException, RepositoryItemUpdateException {
        Assert.notNull((Object)item, (String)"Repository item is required.");
        return this.repositoryService.updateItem(item);
    }

    @Override
    public RepositoryItem rename(String path, String name) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)name, (String)"Name is required.");
        return this.repositoryService.rename(path, name);
    }

    @Override
    public RepositoryItem move(String sourcePath, String destinationPath) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemMoveException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        return this.repositoryService.move(sourcePath, destinationPath);
    }

    @Override
    public RepositoryItem copy(String sourcePath, String destinationPath) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemCopyException {
        Assert.hasText((String)sourcePath, (String)"Source path is required.");
        Assert.hasText((String)destinationPath, (String)"Destination path is required.");
        return this.repositoryService.copy(sourcePath, destinationPath);
    }

    @Override
    public List<String> delete(String path) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.delete(path);
    }

    @Override
    public List<VersionDeleteInfo> deleteVersions(String path, Set<String> versions) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.notEmpty(versions, (String)"Versions are required.");
        return this.repositoryService.deleteVersions(path, versions);
    }

    @Override
    public List<String> permanentlyDelete(String path) throws RepositoryItemNotFoundException, RepositoryItemDeleteException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.permanentlyDelete(path);
    }

    @Override
    public RepositoryFile enableVersioning(String path, String comment, String startingVersion) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.enableVersioning(path, comment, startingVersion);
    }

    @Override
    public RepositoryFile disableVersioning(String path, String comment) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.disableVersioning(path, comment);
    }

    @Override
    public RepositoryFile lockFile(String path) throws RepositoryItemNotFoundException, RepositoryItemLockException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.lockFile(path);
    }

    @Override
    public RepositoryFile unlockFile(String path) throws RepositoryItemNotFoundException, RepositoryItemUnlockException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.unlockFile(path);
    }

    @Override
    public boolean exists(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.exists(path);
    }

    @Override
    public RepositoryContext getTopLevelContextByName(String name) throws RepositoryItemNotFoundException {
        Assert.hasText((String)name, (String)"Name is required.");
        return this.repositoryService.getTopLevelContextByName(name);
    }

    @Override
    public List<RepositoryContext> getTopLevelContexts() {
        return this.repositoryService.getTopLevelContexts();
    }

    @Override
    public RepositoryItem getItem(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getItem(path);
    }

    @Override
    public RepositoryContext getContext(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getContext(path);
    }

    @Override
    public RepositoryContext getContextById(String id) throws RepositoryItemNotFoundException {
        Assert.hasText((String)id, (String)"Context identifier is required.");
        return this.repositoryService.getContextById(id);
    }

    @Override
    public RepositoryContext getParentMembershipContext(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getParentMembershipContext(path);
    }

    @Override
    public RepositoryFolder getFolder(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getFolder(path);
    }

    @Override
    public RepositoryFile getFile(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getFile(path);
    }

    @Override
    public List<RepositoryItem> getChildren(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getChildren(path);
    }

    @Override
    public List<RepositoryItem> getChildrenByType(String path, String typeId) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)typeId, (String)"Type is required.");
        return this.repositoryService.getChildrenByType(path, typeId);
    }

    @Override
    public RepositoryFile getFileVersion(String path, String version) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)version, (String)"Version is required.");
        return this.repositoryService.getFileVersion(path, version);
    }

    @Override
    public List<RepositoryFile> getFileVersions(String path) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getFileVersions(path);
    }

    @Override
    public List<RepositoryFileVersionInfo> getFileVersionInfos(String path) throws RepositoryItemNotFoundException, RepositoryItemVersioningException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getFileVersionInfos(path);
    }

    @Override
    public RepositoryFile updateFileContents(String path, RepositoryCheckinSpecification spec, String localFilePath) throws RepositoryItemNotFoundException, RepositoryItemCheckoutException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.updateRepositoryFileContents(path, localFilePath, spec);
    }

    @Override
    public void downloadFile(String path, String version, String localFilePath) throws RepositoryItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.clientFileStreamingHelper.downloadRepositoryFile(path, version, localFilePath);
    }

    @Override
    public List<RepositoryStateChangeResult> setState(String path, RepositoryItem.State state, String comment, boolean recurse) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.notNull((Object)((Object)state), (String)"State is required.");
        return this.repositoryService.setState(path, state, comment, recurse);
    }

    @Override
    public RepositoryFile checkout(String path) throws RepositoryItemNotFoundException, RepositoryItemCheckoutException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.checkout(path);
    }

    @Override
    public RepositoryFile undoCheckout(String path) throws RepositoryItemNotFoundException, RepositoryItemUndoCheckoutException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.undoCheckout(path);
    }

    @Override
    public RepositoryFile checkin(String path, RepositoryCheckinSpecification spec) throws RepositoryItemNotFoundException, RepositoryItemCheckinException {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.checkin(path, spec);
    }

    @Override
    public void copyLatestFileVersionToWorkspace(String path) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.repositoryService.copyLatestFileVersionToWorkspace(path);
    }

    @Override
    public SearchResultsInfo searchCheckedOutFiles(CheckedOutFilesQuery query) {
        this.clearCheckedOutFilesSearchResults();
        SearchResultsInfo info = this.repositoryService.searchCheckedOutFiles(query);
        this.token = info.getToken();
        return info;
    }

    @Override
    public List<SynchronizationInfo> getCheckedOutFilesSearchResults(int fromRow, int toRow) throws CheckedOutFilesSearchException {
        Assert.notNull((Object)this.token, (String)"Current search results do not exist, please call searchCheckedOutFiles method before calling this method.");
        return this.internalRepositoryService.internalGetCheckedOutFilesSearchResults(this.token, fromRow, toRow);
    }

    @Override
    public SynchronizationInfo getSynchronizationInfo(String path) {
        Assert.hasText((String)path, (String)"Path is required.");
        return this.repositoryService.getSynchronizationInfo(path);
    }

    @Override
    public List<SynchronizationInfo> getSynchronizationInfos(Set<String> paths, boolean recurse) {
        Assert.notEmpty(paths, (String)"Path is required.");
        return this.repositoryService.getSynchronizationInfos(paths, recurse);
    }

    @Override
    public void clearCheckedOutFilesSearchResults() {
        if (this.token == null) {
            return;
        }
        this.internalRepositoryService.internalClearCheckedOutFilesSearchResults(this.token);
        this.token = null;
    }

    @Override
    public int getPageSizeLimit() {
        return this.repositoryService.getPageSizeLimit();
    }

    @Override
    public void copySpecificFileVersionToWorkspace(String path, String version) throws RepositoryItemNotFoundException {
        Assert.hasText((String)path, (String)"Path is required.");
        this.repositoryService.copySpecificFileVersionToWorkspace(path, version);
    }

    @Override
    public RepositorySearchResults search(SearchQuery query) throws RepositorySearchException {
        Assert.notNull((Object)query, (String)"Search query is required.");
        return this.repositoryService.search(query);
    }

    @Override
    public String batchPrepareUpload(Set<String> paths) {
        return this.internalRepositoryService.batchPrepareUpload(paths);
    }

    @Override
    public String batchPrepareUploadAndExpand(String path) {
        return this.internalRepositoryService.batchPrepareUploadAndExpand(path);
    }

    @Override
    public void internalClearCheckedOutFilesSearchResults(String token) {
        if (token == null) {
            return;
        }
        this.internalRepositoryService.internalClearCheckedOutFilesSearchResults(token);
        this.token = null;
    }

    @Override
    public List<SynchronizationInfo> internalGetCheckedOutFilesSearchResults(String token, int fromRow, int toRow) throws CheckedOutFilesSearchException {
        Assert.notNull((Object)token, (String)"Current search results do not exist, please call search method before calling this method.");
        return this.internalRepositoryService.internalGetCheckedOutFilesSearchResults(token, fromRow, toRow);
    }
}

