/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository.impl;

import com.sas.lsaf.content.impl.ClientFileStreamingHelper;
import com.sas.lsaf.content.repository.BatchRepositoryService;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.core.action.ActionStatus;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.util.Assert;

public class ClientBatchRepositoryServiceImpl
implements BatchRepositoryService {
    private BatchRepositoryService batchRepositoryService;
    private ClientFileStreamingHelper clientFileStreamingHelper;

    @Required
    public void setBatchRepositoryService(BatchRepositoryService batchRepositoryService) {
        this.batchRepositoryService = batchRepositoryService;
    }

    @Required
    public void setClientFileStreamingHelper(ClientFileStreamingHelper clientFileStreamingHelper) {
        this.clientFileStreamingHelper = clientFileStreamingHelper;
    }

    @Override
    public ActionStatus checkout(List<String> paths) {
        Assert.notEmpty(paths, (String)"Paths are required.");
        return this.batchRepositoryService.checkout(paths);
    }

    @Override
    public ActionStatus checkin(List<String> paths, RepositoryCheckinSpecification spec) {
        Assert.notEmpty(paths, (String)"Paths are required.");
        return this.batchRepositoryService.checkin(paths, spec);
    }

    @Override
    public ActionStatus uploadAndExpand(String parentPath, String localFilePath, boolean enableVersioningOnAllNewFiles, RepositoryCheckinSpecification spec, boolean createParentFolders) throws IOException {
        Assert.hasText((String)parentPath, (String)"Parent path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        return this.clientFileStreamingHelper.uploadAndExpandInRepository(parentPath, localFilePath, enableVersioningOnAllNewFiles, spec, createParentFolders);
    }

    @Override
    public void downloadAsZip(Set<String> paths, String localFilePath, boolean overwrite) throws RepositoryItemNotFoundException, IOException {
        Assert.notEmpty(paths, (String)"Paths are required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.clientFileStreamingHelper.downloadAsZipFromRepository(paths, localFilePath, overwrite);
    }
}

