/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository;

import com.sas.lsaf.content.repository.RepositoryFileInfo;
import com.sas.lsaf.content.repository.SynchronizationFileInfo;
import com.sas.lsaf.content.repository.WorkspaceFileInfo;
import java.io.Serializable;

public class SynchronizationInfo
implements Serializable {
    private static final long serialVersionUID = 8839417783690278483L;
    private final String path;
    private final RepositoryFileInfo repositoryFileInfo;
    private final SynchronizationFileInfo synchronizationFileInfo;
    private final WorkspaceFileInfo workspaceFileInfo;
    private final FileStatus fileStatus;
    private final SynchronizationStatus synchronizationStatus;
    private final CheckoutStatus checkoutStatus;

    public SynchronizationInfo(String path, RepositoryFileInfo repositoryFileInfo, SynchronizationFileInfo synchronizationFileInfo, WorkspaceFileInfo workspaceFileInfo, FileStatus fileStatus, SynchronizationStatus synchronizationStatus, CheckoutStatus checkoutStatus) {
        this.path = path;
        this.repositoryFileInfo = repositoryFileInfo;
        this.synchronizationFileInfo = synchronizationFileInfo;
        this.workspaceFileInfo = workspaceFileInfo;
        this.fileStatus = fileStatus;
        this.synchronizationStatus = synchronizationStatus;
        this.checkoutStatus = checkoutStatus;
    }

    public String getPath() {
        return this.path;
    }

    public RepositoryFileInfo getRepositoryFileInfo() {
        return this.repositoryFileInfo;
    }

    public SynchronizationFileInfo getSynchronizationFileInfo() {
        return this.synchronizationFileInfo;
    }

    public WorkspaceFileInfo getWorkspaceFileInfo() {
        return this.workspaceFileInfo;
    }

    public FileStatus getFileStatus() {
        return this.fileStatus;
    }

    public SynchronizationStatus getSynchronizationStatus() {
        return this.synchronizationStatus;
    }

    public CheckoutStatus getCheckoutStatus() {
        return this.checkoutStatus;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynchronizationInfo other = (SynchronizationInfo)obj;
        return !(this.path == null ? other.path != null : !this.path.equals(other.path));
    }

    public String toString() {
        return "SynchronizationInfo [path=" + this.path + ", repositoryFileInfo=" + this.repositoryFileInfo + ", synchronizationFileInfo=" + this.synchronizationFileInfo + ", workspaceFileInfo=" + this.workspaceFileInfo + ", fileStatus=" + (Object)((Object)this.fileStatus) + ", synchronizationStatus=" + (Object)((Object)this.synchronizationStatus) + ", checkoutStatus=" + (Object)((Object)this.checkoutStatus) + "]";
    }

    public static enum CheckoutStatus {
        NOT_CHECKED_OUT,
        CHECKED_OUT,
        MARKED_FOR_ADD;

    }

    public static enum SynchronizationStatus {
        NOT_SYNCED,
        OUT_OF_SYNC,
        IN_SYNC;

    }

    public static enum FileStatus {
        NON_EXISTENT,
        WORKSPACE_ONLY,
        REPOSITORY_ONLY,
        WORKSPACE_AND_REPOSITORY;

    }
}

