/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository;

import com.sas.lsaf.content.repository.CheckedOutFilesQuery;
import com.sas.lsaf.content.repository.CheckedOutFilesSearchException;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryContext;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryFileVersionInfo;
import com.sas.lsaf.content.repository.RepositoryFolder;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemCheckinException;
import com.sas.lsaf.content.repository.RepositoryItemCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemCopyException;
import com.sas.lsaf.content.repository.RepositoryItemDeleteException;
import com.sas.lsaf.content.repository.RepositoryItemExistsException;
import com.sas.lsaf.content.repository.RepositoryItemLockException;
import com.sas.lsaf.content.repository.RepositoryItemMoveException;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryItemUndoCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemUnlockException;
import com.sas.lsaf.content.repository.RepositoryItemUpdateException;
import com.sas.lsaf.content.repository.RepositoryItemVersioningException;
import com.sas.lsaf.content.repository.RepositorySearchException;
import com.sas.lsaf.content.repository.RepositorySearchResults;
import com.sas.lsaf.content.repository.RepositorySharedFolder;
import com.sas.lsaf.content.repository.RepositoryStateChangeResult;
import com.sas.lsaf.content.repository.SearchQuery;
import com.sas.lsaf.content.repository.SynchronizationInfo;
import com.sas.lsaf.content.repository.VersionDeleteInfo;
import com.sas.lsaf.core.SearchResultsInfo;
import com.sas.lsaf.security.membership.MembershipContextNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Set;

public interface RepositoryService {
    public RepositoryContext createContext(String var1, String var2) throws RepositoryItemNotFoundException, RepositoryItemExistsException;

    public RepositoryFolder createFolder(String var1, boolean var2) throws RepositoryItemNotFoundException, RepositoryItemExistsException;

    public RepositorySharedFolder createSharedFolder(String var1) throws RepositoryItemNotFoundException, RepositoryItemExistsException;

    public RepositoryFile createFile(String var1, String var2, String var3, boolean var4) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException;

    public RepositoryFile createVersionedFile(String var1, String var2, String var3, String var4, boolean var5) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException;

    public RepositoryItem updateItem(RepositoryItem var1) throws RepositoryItemNotFoundException, RepositoryItemUpdateException;

    public RepositoryItem rename(String var1, String var2) throws RepositoryItemNotFoundException, RepositoryItemExistsException;

    public RepositoryItem move(String var1, String var2) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemMoveException;

    public RepositoryItem copy(String var1, String var2) throws RepositoryItemNotFoundException, RepositoryItemExistsException, RepositoryItemCopyException;

    public List<String> delete(String var1) throws RepositoryItemNotFoundException, RepositoryItemDeleteException;

    public List<VersionDeleteInfo> deleteVersions(String var1, Set<String> var2) throws RepositoryItemNotFoundException, RepositoryItemDeleteException;

    public List<String> permanentlyDelete(String var1) throws RepositoryItemNotFoundException, RepositoryItemDeleteException;

    public RepositoryFile enableVersioning(String var1, String var2, String var3) throws RepositoryItemNotFoundException, RepositoryItemVersioningException;

    public RepositoryFile disableVersioning(String var1, String var2) throws RepositoryItemNotFoundException, RepositoryItemVersioningException;

    public RepositoryFile lockFile(String var1) throws RepositoryItemNotFoundException, RepositoryItemLockException;

    public RepositoryFile unlockFile(String var1) throws RepositoryItemNotFoundException, RepositoryItemUnlockException;

    public boolean exists(String var1);

    public RepositoryItem getItem(String var1) throws RepositoryItemNotFoundException;

    public RepositoryContext getTopLevelContextByName(String var1) throws RepositoryItemNotFoundException;

    public List<RepositoryContext> getTopLevelContexts();

    public SynchronizationInfo getSynchronizationInfo(String var1);

    public List<SynchronizationInfo> getSynchronizationInfos(Set<String> var1, boolean var2);

    public RepositoryContext getContext(String var1) throws RepositoryItemNotFoundException;

    public RepositoryContext getContextById(String var1) throws RepositoryItemNotFoundException;

    public RepositoryContext getParentMembershipContext(String var1) throws RepositoryItemNotFoundException, MembershipContextNotFoundException;

    public RepositoryFolder getFolder(String var1) throws RepositoryItemNotFoundException;

    public RepositoryFile getFile(String var1) throws RepositoryItemNotFoundException;

    public List<RepositoryItem> getChildren(String var1) throws RepositoryItemNotFoundException;

    public List<RepositoryItem> getChildrenByType(String var1, String var2) throws RepositoryItemNotFoundException;

    public RepositoryFile getFileVersion(String var1, String var2) throws RepositoryItemNotFoundException;

    public List<RepositoryFile> getFileVersions(String var1) throws RepositoryItemNotFoundException, RepositoryItemVersioningException;

    public List<RepositoryFileVersionInfo> getFileVersionInfos(String var1) throws RepositoryItemNotFoundException, RepositoryItemVersioningException;

    public void downloadFile(String var1, String var2, String var3) throws RepositoryItemNotFoundException, IOException;

    public RepositoryFile updateFileContents(String var1, RepositoryCheckinSpecification var2, String var3) throws RepositoryItemNotFoundException, RepositoryItemVersioningException, RepositoryItemCheckoutException, IOException;

    public List<RepositoryStateChangeResult> setState(String var1, RepositoryItem.State var2, String var3, boolean var4) throws RepositoryItemNotFoundException;

    public RepositoryFile checkout(String var1) throws RepositoryItemNotFoundException, RepositoryItemCheckoutException;

    public RepositoryFile undoCheckout(String var1) throws RepositoryItemNotFoundException, RepositoryItemUndoCheckoutException;

    public RepositoryFile checkin(String var1, RepositoryCheckinSpecification var2) throws RepositoryItemNotFoundException, RepositoryItemCheckinException;

    public void copyLatestFileVersionToWorkspace(String var1) throws RepositoryItemNotFoundException;

    public void copySpecificFileVersionToWorkspace(String var1, String var2) throws RepositoryItemNotFoundException;

    public SearchResultsInfo searchCheckedOutFiles(CheckedOutFilesQuery var1);

    public RepositorySearchResults search(SearchQuery var1) throws RepositorySearchException;

    public List<SynchronizationInfo> getCheckedOutFilesSearchResults(int var1, int var2) throws CheckedOutFilesSearchException;

    public void clearCheckedOutFilesSearchResults();

    public int getPageSizeLimit();
}

