/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.repository;

import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.VersionLimits;
import com.sas.lsaf.core.Attribute;
import java.util.Date;
import java.util.List;

public class RepositoryFile
extends RepositoryItem {
    private static final long serialVersionUID = 7854585003876860153L;
    private final long size;
    private final boolean checkedOut;
    private final String checkedOutBy;
    private final Date checkedOutDate;
    private final boolean versioned;
    private final String version;
    private final String comment;
    private final boolean locked;
    private String digest;
    private SigningStatus signingStatus = SigningStatus.NONE;
    private VersionLimits versionLimits;

    public RepositoryFile(String typeId, String id, String name, String path, long revision, RepositoryItem.State state, String createdBy, Date created, String lastModifiedBy, Date lastModified, String propertiesLastModifiedBy, Date propertiesLastModified, String description, RepositoryItem.Syncable syncable, List<Attribute> attributes, long size, boolean checkedOut, String checkedOutBy, Date checkedOutDate, boolean versioned, String version, String comment, boolean locked, SigningStatus signingStatus, VersionLimits versionLimits, String digest) {
        super(typeId, id, name, path, revision, state, createdBy, created, lastModifiedBy, lastModified, propertiesLastModifiedBy, propertiesLastModified, description, syncable, attributes);
        this.size = size;
        this.checkedOut = checkedOut;
        this.checkedOutBy = checkedOutBy;
        this.checkedOutDate = checkedOutDate;
        this.versioned = versioned;
        this.version = version;
        this.comment = comment;
        this.locked = locked;
        this.signingStatus = signingStatus;
        this.versionLimits = versionLimits;
        this.digest = digest;
    }

    public long getSize() {
        return this.size;
    }

    public boolean isCheckedOut() {
        return this.checkedOut;
    }

    public String getCheckedOutBy() {
        return this.checkedOutBy;
    }

    public Date getCheckedOutDate() {
        return this.checkedOutDate;
    }

    public boolean isVersioned() {
        return this.versioned;
    }

    public String getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getDigest() {
        return this.digest;
    }

    public SigningStatus getSigningStatus() {
        return this.signingStatus;
    }

    public VersionLimits getVersionLimits() {
        return this.versionLimits;
    }

    public void setVersionLimits(VersionLimits versionLimits) {
        this.versionLimits = versionLimits;
    }

    public Integer getMajorLimit() {
        return this.versionLimits == null ? null : this.versionLimits.getMajorVersionLimit();
    }

    public Integer getMinorLimit() {
        return this.versionLimits == null ? null : this.versionLimits.getMinorVersionLimit();
    }

    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        result = 31 * result + (this.getTypeId() == null ? 0 : this.getTypeId().hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryFile other = (RepositoryFile)obj;
        if (this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId())) {
            return false;
        }
        return !(this.getTypeId() == null ? other.getTypeId() != null : !this.getTypeId().equals(other.getTypeId()));
    }

    @Override
    public String toString() {
        return "RepositoryFile [id=" + this.getId() + ", type=" + this.getTypeId() + ", path=" + this.getPath() + ", version=" + this.version + "]";
    }

    public static enum SigningStatus {
        NONE,
        PREVIOUS,
        CURRENT,
        CURRENT_AND_PREVIOUS;

    }
}

