/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lsaf.content.impl;

import com.sas.lsaf.client.HttpException;
import com.sas.lsaf.content.repository.RepositoryCheckinSpecification;
import com.sas.lsaf.content.repository.RepositoryFile;
import com.sas.lsaf.content.repository.RepositoryItem;
import com.sas.lsaf.content.repository.RepositoryItemCheckoutException;
import com.sas.lsaf.content.repository.RepositoryItemExistsException;
import com.sas.lsaf.content.repository.RepositoryItemLockedException;
import com.sas.lsaf.content.repository.RepositoryItemNotFoundException;
import com.sas.lsaf.content.repository.RepositoryService;
import com.sas.lsaf.content.repository.VersionType;
import com.sas.lsaf.content.repository.impl.InternalRepositoryService;
import com.sas.lsaf.content.workspace.WorkspaceFile;
import com.sas.lsaf.content.workspace.WorkspaceItem;
import com.sas.lsaf.content.workspace.WorkspaceItemExistsException;
import com.sas.lsaf.content.workspace.WorkspaceItemNotFoundException;
import com.sas.lsaf.content.workspace.WorkspaceService;
import com.sas.lsaf.content.workspace.impl.InternalWorkspaceService;
import com.sas.lsaf.core.AccessDeniedException;
import com.sas.lsaf.core.IllegalPathException;
import com.sas.lsaf.core.SystemException;
import com.sas.lsaf.core.ValidationException;
import com.sas.lsaf.core.action.ActionStatus;
import com.sas.lsaf.core.action.ActionStatusDetail;
import com.sas.lsaf.core.action.impl.InternalActionStatusService;
import com.sas.lsaf.core.type.IllegalChildTypeException;
import com.sas.lsaf.core.utils.impl.CollectionUtils;
import com.sas.lsaf.core.utils.impl.PathUtils;
import com.sas.lsaf.core.utils.impl.UriUtils;
import com.sas.lsaf.svcs.core.utils.client.Assert;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.springframework.beans.factory.annotation.Required;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;

public class ClientFileStreamingHelper {
    private static final Log LOG = LogFactory.getLog(ClientFileStreamingHelper.class);
    private static final String PARAMETER_ACTION_STATUS = "actionStatusId";
    private static final String PARAMETER_CREATE_PARENT_FOLDERS = "createParentFolders";
    private static final String PARAMETER_OVERWRITE_EXISTING = "overwriteExisting";
    private static final String PARAMETER_UNZIP = "unzip";
    private static final String PARAMETER_UNZIP_TYPE = "unziptype";
    private static final String PARAMETER_URI = "uri";
    private static final String PARAMETER_VTYPE = "vtype";
    private static final String PARAMETER_VCUSTOM = "vcustom";
    private static final String PARAMETER_VENABLE = "venable";
    private static final String PARAMETER_VCOMMENT = "vcomment";
    private static final String PARAMETER_ZIP = "zip";
    private static final String EMPTY = "";
    private static final String DEFAULT_VERSION = "0.1";
    private static final String UPLOAD_WARN_FILE_EXISTS = "file.upload.warn.file.exists";
    private static final String UPLOAD_ERROR_FILE_CHECKEDOUT = "file.upload.error.file.checkedout";
    private static final String UPLOAD_ERROR_FILE_LOCKED = "file.upload.error.file.locked";
    private static final String UPLOAD_ERROR_FOLDER_EXISTS = "file.upload.error.folder.exists";
    private static final String UPLOAD_ERROR_FILE_EXISTS = "file.upload.error.file.check.in.failed";
    private static final String UPLOAD_ERROR_PERMISSION_READ = "file.upload.error.permission.read";
    private static final String UPLOAD_ERROR_PERMISSION_WRITE_CONTENT = "file.upload.error.permission.write.content";
    private static final String UPLOAD_ERROR_PERMISSION_DEFAULT_READ = "file.upload.error.permission.default.read";
    private static final String UPLOAD_ERROR_PARENT_PERMISSION = "file.upload.error.parent.permission";
    private static final String UPLOAD_ERROR_PRIVILEGE = "file.upload.error.privilege";
    private static final String UPLOAD_ERROR_UNSUPPORTED = "file.upload.error.unsupported";
    private static final String UPLOAD_ERROR_VALIDATION = "file.upload.error.validation";
    private static final String UPLOAD_ERROR_VERSION_VALIDATION = "file.upload.error.invalid.version";
    private static final String UPLOAD_ERROR_MISSING = "file.upload.error.missing";
    private HttpComponentsHttpInvokerRequestExecutor httpInvoker;
    private String uploadUrl;
    private String downloadUrl;
    private int socketTimeout = 0;
    private int connectTimeout = 10000;
    private RepositoryService repositoryService;
    private InternalRepositoryService internalRepositoryService;
    private WorkspaceService workspaceService;
    private InternalWorkspaceService internalWorkspaceService;
    private InternalActionStatusService internalActionStatusService;

    private RepositoryFile doUploadRepositoryFile(String path, String token, HttpEntity httpEntity) throws RepositoryItemNotFoundException, RepositoryItemExistsException {
        ActionStatus as = this.doUploadFile(httpEntity, token);
        if (as.getCompletionStatus() == ActionStatus.CompletionStatus.ERROR || as.getCompletionStatus() == ActionStatus.CompletionStatus.WARN) {
            ActionStatusDetail asd = as.getDetails().get(0);
            if (asd.getMessageCode().equals(UPLOAD_WARN_FILE_EXISTS)) {
                throw new RepositoryItemExistsException(path, asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_MISSING)) {
                throw new RepositoryItemNotFoundException(path, asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FILE_EXISTS)) {
                throw new RepositoryItemExistsException(path, asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FOLDER_EXISTS)) {
                throw new RepositoryItemExistsException(path, asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_UNSUPPORTED)) {
                throw new IllegalChildTypeException(asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_VALIDATION) || asd.getMessageCode().equals(UPLOAD_ERROR_VERSION_VALIDATION)) {
                throw new ValidationException(asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_PARENT_PERMISSION) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_DEFAULT_READ) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_READ) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_WRITE_CONTENT) || asd.getMessageCode().equals(UPLOAD_ERROR_PRIVILEGE)) {
                throw new AccessDeniedException(asd.getMessage());
            }
            throw new SystemException(asd.getMessage());
        }
        return (RepositoryFile)this.repositoryService.getItem(path);
    }

    private void doValidateDownloadPaths(Set<String> paths) {
        for (String path : paths) {
            if (!path.equals("/") && !path.contains("/.")) continue;
            throw new IllegalPathException("Path is not valid for download:  " + path);
        }
    }

    private void doAssertWorkspacePathIsToFile(String path) throws WorkspaceItemNotFoundException {
        WorkspaceItem workspaceItem = this.workspaceService.getItem(path);
        if (!(workspaceItem instanceof WorkspaceFile)) {
            throw new IllegalPathException("Path must be to a file not a container.");
        }
    }

    private void doAssertRepositoryPathIsToFile(String path) throws RepositoryItemNotFoundException {
        RepositoryItem repositoryItem = this.repositoryService.getItem(path);
        if (!(repositoryItem instanceof RepositoryFile)) {
            throw new IllegalPathException("Path must be to a file not a container.");
        }
    }

    private void doValidateVersion(String version) throws ValidationException {
        if (version != null && !version.isEmpty()) {
            int dot = version.indexOf(46);
            if (dot == -1) {
                throw new ValidationException("Invalid version syntax, missing dot notation:  '" + version + "'");
            }
            int newMajor = 0;
            String majorString = version.substring(0, dot);
            try {
                newMajor = Integer.parseInt(majorString);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid version syntax, major specification is not an integer:  '" + version + "'");
            }
            if (majorString.length() > 1 && majorString.startsWith("0")) {
                throw new ValidationException("Invalid version syntax, major specification cannot lead with zeroes:  '" + version + "'");
            }
            if (newMajor > 99999) {
                throw new ValidationException("Invalid version syntax, major specification cannot exceed 99999:  '" + version + "'");
            }
            int newMinor = 0;
            String minorString = version.substring(dot + 1);
            if (minorString.length() > 1 && minorString.startsWith("0")) {
                throw new ValidationException("Invalid version syntax, minor specification cannot lead with zeroes:  '" + version + "'");
            }
            try {
                newMinor = Integer.parseInt(minorString);
            }
            catch (Exception e) {
                throw new ValidationException("Invalid version syntax, minor specification is not an integer:  '" + version + "'");
            }
            if (newMinor > 99999) {
                throw new ValidationException("Invalid version syntax, minor specification cannot exceed 99999:  '" + version + "'");
            }
            if (newMajor == 0 && newMinor == 0) {
                throw new ValidationException("Invalid version syntax. 0.0 is not a valid version.");
            }
            if (newMajor < 0) {
                throw new ValidationException("Invalid version syntax. Version value cannot be negative.");
            }
        }
    }

    private RepositoryCheckinSpecification doValidateCheckinSpecification(RepositoryCheckinSpecification spec) {
        RepositoryCheckinSpecification cs = spec;
        if (cs == null) {
            return new RepositoryCheckinSpecification(EMPTY, VersionType.MAJOR, EMPTY);
        }
        if (cs.getCustomVersion() == null || cs.getCustomVersion().trim().isEmpty()) {
            cs.setCustomVersion("1.0");
        }
        if (cs.getVersionType() == null) {
            cs.setVersionType(VersionType.MAJOR);
        } else if (cs.getVersionType() == VersionType.CUSTOM && (cs.getCustomVersion() == null || cs.getCustomVersion().equals(EMPTY))) {
            cs.setCustomVersion(DEFAULT_VERSION);
        }
        cs.setComment(this.doValidateComment(cs.getComment()));
        return cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownloadFile(String uri, String localFilePath) throws IOException {
        File file = PathUtils.assertFileIsWritable(localFilePath);
        try (FileOutputStream out = new FileOutputStream(file);){
            HttpGet httpGet = new HttpGet(this.downloadUrl + "/" + uri);
            httpGet.setConfig(RequestConfig.custom().setExpectContinueEnabled(true).setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build());
            HttpResponse httpResponse = this.httpInvoker.getHttpClient().execute((HttpUriRequest)httpGet);
            try (InputStream in = httpResponse.getEntity().getContent();){
                StatusLine status = httpResponse.getStatusLine();
                if (status.getStatusCode() != 200) {
                    if (status.getStatusCode() == 404) {
                        LOG.error((Object)("File download failed with http status of " + status));
                        boolean bl = false;
                        return bl;
                    }
                    LOG.error((Object)("File download failed with http status of " + status));
                    throw new IOException("File download failed [" + status + "]: ");
                }
                int count = IOUtils.copy((InputStream)in, (OutputStream)out);
                LOG.debug((Object)("transferred " + count + " bytes"));
                return true;
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected exception during file download.", t);
            throw new SystemException("Error while attempting to download file: " + t.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean doDownloadAsZip(String uris, String localFilePath, boolean overwrite) throws IOException {
        File file = new File(localFilePath);
        if (file.exists() && !overwrite) {
            throw new IOException("The download did not occur. The zip file exists, and the overwrite option was set to false.");
        }
        PathUtils.assertFileIsWritable(file);
        try (FileOutputStream out = new FileOutputStream(file);){
            HttpGet httpGet = new HttpGet(new URIBuilder(this.downloadUrl).addParameter(PARAMETER_ZIP, "true").addParameter(PARAMETER_URI, uris).build());
            httpGet.setConfig(RequestConfig.custom().setExpectContinueEnabled(true).setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build());
            HttpResponse httpResponse = this.httpInvoker.getHttpClient().execute((HttpUriRequest)httpGet);
            StatusLine status = httpResponse.getStatusLine();
            if (status.getStatusCode() != 200) {
                LOG.error((Object)("File download failed with http status of " + status));
                if (status.getStatusCode() == 404) {
                    boolean bl = false;
                    return bl;
                }
                if (status.getStatusCode() != 401) throw new SystemException("Error occurred during download operation: " + status);
                throw new AccessDeniedException("Error occurred during download. You do not have appropriate permissions on one or more items selected for download.");
            }
            try (InputStream in = httpResponse.getEntity().getContent();){
                int count = IOUtils.copy((InputStream)in, (OutputStream)out);
                LOG.debug((Object)("transferred " + count + " bytes"));
                return true;
            }
            finally {
                httpGet.releaseConnection();
            }
        }
        catch (AccessDeniedException e) {
            throw e;
        }
        catch (SystemException e) {
            throw e;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected exception during download.", t);
            throw new SystemException("Error while attempting to download file: " + t.getLocalizedMessage());
        }
    }

    private ActionStatus doUploadFile(HttpEntity httpEntity, String token) {
        HttpPost httpPost = new HttpPost(this.uploadUrl);
        httpPost.setEntity(httpEntity);
        httpPost.setConfig(RequestConfig.custom().setExpectContinueEnabled(true).setSocketTimeout(this.socketTimeout).setConnectTimeout(this.connectTimeout).build());
        try {
            ActionStatus as;
            HttpResponse response = this.httpInvoker.getHttpClient().execute((HttpUriRequest)httpPost);
            StatusLine status = response.getStatusLine();
            if (status.getStatusCode() != 200) {
                LOG.error((Object)("File upload failed with http status of " + status));
                throw new HttpException(status.getStatusCode(), "Did not receive successful HTTP response: status code = " + status.getStatusCode() + ", status message = [" + status.getReasonPhrase() + "]");
            }
            ActionStatus actionStatus = as = this.internalActionStatusService.getCompletedActionStatusById(token);
            return actionStatus;
        }
        catch (Throwable t) {
            LOG.error((Object)"Unexpected exception during file upload.", t);
            throw new SystemException("Error while attempting to upload file: " + t.getLocalizedMessage());
        }
        finally {
            httpPost.releaseConnection();
            this.internalActionStatusService.clearById(token);
        }
    }

    private String doValidateComment(String comment) {
        if (comment == null) {
            return EMPTY;
        }
        return UriUtils.encode(comment);
    }

    @Required
    public void setHttpInvoker(HttpComponentsHttpInvokerRequestExecutor httpInvoker) {
        this.httpInvoker = httpInvoker;
    }

    @Required
    public void setUploadUrl(String uploadUrl) {
        this.uploadUrl = uploadUrl;
    }

    @Required
    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    @Required
    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    @Required
    public void setInternalRepositoryService(InternalRepositoryService internalRepositoryService) {
        this.internalRepositoryService = internalRepositoryService;
    }

    @Required
    public void setWorkspaceService(WorkspaceService workspaceService) {
        this.workspaceService = workspaceService;
    }

    @Required
    public void setInternalWorkspaceService(InternalWorkspaceService internalWorkspaceService) {
        this.internalWorkspaceService = internalWorkspaceService;
    }

    @Required
    public void setInternalActionStatusService(InternalActionStatusService internalActionStatusService) {
        this.internalActionStatusService = internalActionStatusService;
    }

    public void setSocketTimeout(int socketTimeout) {
        LOG.info((Object)("Using socket timeout of " + socketTimeout));
        this.socketTimeout = socketTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        LOG.info((Object)("Using connection timeout of " + connectTimeout));
        this.connectTimeout = connectTimeout;
    }

    public RepositoryFile createRepositoryFile(String path, String localFilePath, String comment, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        PathUtils.validatePath(path);
        String uri = UriUtils.toRepositoryUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        String c = this.doValidateComment(comment);
        String token = this.internalRepositoryService.batchPrepareUpload(CollectionUtils.asSet(path));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_CREATE_PARENT_FOLDERS, (ContentBody)new StringBody(Boolean.toString(createParentFolders), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VENABLE, (ContentBody)new StringBody(Boolean.toString(false), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCOMMENT, (ContentBody)new StringBody(c, ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(false), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        return this.doUploadRepositoryFile(path, token, httpEntity);
    }

    public RepositoryFile createRepositoryVersionedFile(String path, String localFilePath, String startingVersion, String comment, boolean createParentFolders) throws RepositoryItemNotFoundException, RepositoryItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        Assert.hasText((String)startingVersion, (String)"Starting version is required.");
        PathUtils.validatePath(path);
        this.doValidateVersion(startingVersion);
        String uri = UriUtils.toRepositoryUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        String c = this.doValidateComment(comment);
        String token = this.internalRepositoryService.batchPrepareUpload(CollectionUtils.asSet(path));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_CREATE_PARENT_FOLDERS, (ContentBody)new StringBody(Boolean.toString(createParentFolders), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VENABLE, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCOMMENT, (ContentBody)new StringBody(c, ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCUSTOM, (ContentBody)new StringBody(startingVersion, ContentType.TEXT_PLAIN)).addPart(PARAMETER_VTYPE, (ContentBody)new StringBody(VersionType.CUSTOM.name(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(false), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        return this.doUploadRepositoryFile(path, token, httpEntity);
    }

    public WorkspaceFile createWorkspaceFile(String path, String localFilePath, boolean createParentFolders) throws WorkspaceItemNotFoundException, WorkspaceItemExistsException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        PathUtils.validatePath(path);
        String uri = UriUtils.toWorkspaceUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        String token = this.internalWorkspaceService.batchPrepareUpload(CollectionUtils.asSet(path));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_CREATE_PARENT_FOLDERS, (ContentBody)new StringBody(Boolean.toString(createParentFolders), ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(false), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        ActionStatus as = this.doUploadFile(httpEntity, token);
        if (as.getCompletionStatus() == ActionStatus.CompletionStatus.ERROR) {
            ActionStatusDetail asd = as.getDetails().get(0);
            if (asd.getMessageCode().equals(UPLOAD_ERROR_MISSING)) {
                throw new WorkspaceItemNotFoundException(path, "Parent path does not exist.");
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FILE_EXISTS)) {
                throw new WorkspaceItemExistsException(path, "Repository item exists.");
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FOLDER_EXISTS)) {
                throw new WorkspaceItemExistsException(path, asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_VALIDATION)) {
                throw new ValidationException(asd.getMessage());
            }
            throw new SystemException(asd.getMessage());
        }
        if (as.getCompletionStatus() == ActionStatus.CompletionStatus.WARN) {
            ActionStatusDetail asd = as.getDetails().get(0);
            throw new WorkspaceItemExistsException(path, asd.getMessage());
        }
        return (WorkspaceFile)this.workspaceService.getItem(path);
    }

    public ActionStatus uploadAndExpandInRepository(String path, String localFilePath, boolean enableVersioning, RepositoryCheckinSpecification spec, boolean createParentFolders) throws IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        PathUtils.validatePath(path);
        String uri = UriUtils.toRepositoryUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        RepositoryCheckinSpecification cs = this.doValidateCheckinSpecification(spec);
        String token = this.internalRepositoryService.batchPrepareUploadAndExpand(path);
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_CREATE_PARENT_FOLDERS, (ContentBody)new StringBody(Boolean.toString(createParentFolders), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VENABLE, (ContentBody)new StringBody(Boolean.toString(enableVersioning), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCOMMENT, (ContentBody)new StringBody(cs.getComment(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCUSTOM, (ContentBody)new StringBody(cs.getCustomVersion(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VTYPE, (ContentBody)new StringBody(cs.getVersionType().name(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_UNZIP, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_UNZIP_TYPE, (ContentBody)new StringBody(FilenameUtils.getExtension((String)localFilePath), ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        return this.doUploadFile(httpEntity, token);
    }

    public ActionStatus uploadAndExpandInWorkspace(String path, String localFilePath, boolean createParentFolders) {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        PathUtils.validatePath(path);
        try {
            String uri = UriUtils.toWorkspaceUri(path);
            File file = PathUtils.assertFileIsReadable(localFilePath);
            String token = this.internalWorkspaceService.batchPrepareUploadAndExpand(path);
            HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_CREATE_PARENT_FOLDERS, (ContentBody)new StringBody(Boolean.toString(createParentFolders), ContentType.TEXT_PLAIN)).addPart(PARAMETER_UNZIP, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_UNZIP_TYPE, (ContentBody)new StringBody(FilenameUtils.getExtension((String)localFilePath), ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
            return this.doUploadFile(httpEntity, token);
        }
        catch (IOException e) {
            throw new SystemException(e.getMessage(), e);
        }
    }

    public void downloadRepositoryFile(String path, String version, String localFilePath) throws RepositoryItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.doAssertRepositoryPathIsToFile(path);
        this.doValidateVersion(version);
        String uri = UriUtils.toRepositoryUri(path, version);
        if (!this.doDownloadFile(uri, localFilePath)) {
            throw new RepositoryItemNotFoundException(uri, "Repository file does not exist.");
        }
    }

    public void downloadWorkspaceFile(String path, String localFilePath) throws WorkspaceItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.doAssertWorkspacePathIsToFile(path);
        String uri = UriUtils.toWorkspaceUri(path);
        if (!this.doDownloadFile(uri, localFilePath)) {
            throw new WorkspaceItemNotFoundException(uri, "Workspace file does not exist.");
        }
    }

    public void downloadAsZipFromRepository(Set<String> paths, String localFilePath, boolean overwrite) throws RepositoryItemNotFoundException, IOException {
        Assert.notEmpty(paths, (String)"Paths are required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        this.doValidateDownloadPaths(paths);
        String uris = UriUtils.toRepositoryUris(paths);
        if (!this.doDownloadAsZip(uris, localFilePath, overwrite)) {
            throw new RepositoryItemNotFoundException(null, "One of the paths specified for download does not exist.");
        }
    }

    public void downloadAsZipFromWorkspace(Set<String> paths, String localFilePath, boolean overwrite) throws WorkspaceItemNotFoundException, IOException {
        Assert.notEmpty(paths, (String)"Paths are required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        String uris = UriUtils.toWorkspaceUris(paths);
        if (!this.doDownloadAsZip(uris, localFilePath, overwrite)) {
            throw new WorkspaceItemNotFoundException(null, "One of the paths specified for download does not exist.");
        }
    }

    public RepositoryFile updateRepositoryFileContents(String path, String localFilePath, RepositoryCheckinSpecification spec) throws RepositoryItemNotFoundException, RepositoryItemCheckoutException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        PathUtils.validatePath(path);
        this.doAssertRepositoryPathIsToFile(path);
        String uri = UriUtils.toRepositoryUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        RepositoryCheckinSpecification cs = this.doValidateCheckinSpecification(spec);
        this.doValidateVersion(cs.getCustomVersion());
        String token = this.internalRepositoryService.batchPrepareUpload(CollectionUtils.asSet(path));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCOMMENT, (ContentBody)new StringBody(cs.getComment(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VCUSTOM, (ContentBody)new StringBody(cs.getCustomVersion(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_VTYPE, (ContentBody)new StringBody(cs.getVersionType().name(), ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        ActionStatus as = this.doUploadFile(httpEntity, token);
        if (as.getCompletionStatus() == ActionStatus.CompletionStatus.ERROR) {
            ActionStatusDetail asd = as.getDetails().get(0);
            if (asd.getMessageCode().equals(UPLOAD_ERROR_MISSING)) {
                throw new RepositoryItemNotFoundException(path, "Repository file does not exist.");
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FILE_LOCKED)) {
                throw new RepositoryItemLockedException(path, "Repository file could not be updated because it is locked.");
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_FILE_CHECKEDOUT)) {
                throw new RepositoryItemCheckoutException(path, "Repository file is checked out.");
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_VALIDATION) || asd.getMessageCode().equals(UPLOAD_ERROR_VERSION_VALIDATION)) {
                throw new ValidationException(asd.getMessage());
            }
            if (asd.getMessageCode().equals(UPLOAD_ERROR_PARENT_PERMISSION) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_DEFAULT_READ) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_READ) || asd.getMessageCode().equals(UPLOAD_ERROR_PERMISSION_WRITE_CONTENT) || asd.getMessageCode().equals(UPLOAD_ERROR_PRIVILEGE)) {
                throw new AccessDeniedException(asd.getMessage());
            }
            throw new SystemException(asd.getMessage());
        }
        return (RepositoryFile)this.repositoryService.getItem(path);
    }

    public WorkspaceFile updateWorkspaceFileContents(String path, String localFilePath) throws WorkspaceItemNotFoundException, IOException {
        Assert.hasText((String)path, (String)"Path is required.");
        Assert.hasText((String)localFilePath, (String)"Local file path is required.");
        Assert.isTrue((boolean)(this.workspaceService.getItem(path) instanceof WorkspaceFile), (String)"Path must be to a file, not a folder.");
        PathUtils.validatePath(path);
        String uri = UriUtils.toWorkspaceUri(path);
        File file = PathUtils.assertFileIsReadable(localFilePath);
        String token = this.internalWorkspaceService.batchPrepareUpload(CollectionUtils.asSet(path));
        HttpEntity httpEntity = MultipartEntityBuilder.create().addPart(PARAMETER_URI, (ContentBody)new StringBody(uri, ContentType.TEXT_PLAIN)).addPart(PARAMETER_ACTION_STATUS, (ContentBody)new StringBody(token, ContentType.TEXT_PLAIN)).addPart(PARAMETER_OVERWRITE_EXISTING, (ContentBody)new StringBody(Boolean.toString(true), ContentType.TEXT_PLAIN)).addPart(file.getName(), (ContentBody)new FileBody(file)).build();
        ActionStatus as = this.doUploadFile(httpEntity, token);
        if (as.getCompletionStatus() == ActionStatus.CompletionStatus.ERROR) {
            ActionStatusDetail asd = as.getDetails().get(0);
            if (asd.getMessageCode().equals(UPLOAD_ERROR_MISSING)) {
                throw new WorkspaceItemNotFoundException(path, "Workspace file does not exist.");
            }
            throw new SystemException(asd.getMessage());
        }
        return (WorkspaceFile)this.workspaceService.getItem(path);
    }
}

